/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.writer;

import io.mantisrx.connector.iceberg.sink.writer.IcebergWriter;
import io.mantisrx.connector.iceberg.sink.writer.MantisDataFile;
import io.mantisrx.connector.iceberg.sink.writer.MantisRecord;
import io.mantisrx.connector.iceberg.sink.writer.config.WriterConfig;
import io.mantisrx.runtime.WorkerInfo;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIcebergWriter
implements IcebergWriter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultIcebergWriter.class);
    private final Map<String, String> tableProperties = new HashMap<String, String>();
    private final WriterConfig config;
    private final WorkerInfo workerInfo;
    private final Table table;
    private final PartitionSpec spec;
    private final FileFormat format;
    private final LocationProvider locationProvider;
    private FileAppender<Record> appender;
    private OutputFile file;
    private StructLike partitionKey;
    @Nullable
    private Long lowWatermark;

    public DefaultIcebergWriter(WriterConfig config, WorkerInfo workerInfo, Table table, LocationProvider locationProvider) {
        this.config = config;
        this.workerInfo = workerInfo;
        this.table = table;
        this.spec = table.spec();
        this.format = FileFormat.valueOf((String)config.getWriterFileFormat());
        this.locationProvider = locationProvider;
        this.tableProperties.putAll(table.properties());
        if (!this.tableProperties.containsKey("write.parquet.compression-codec")) {
            this.tableProperties.put("write.parquet.compression-codec", CompressionCodecName.ZSTD.name());
        }
    }

    @Override
    public void open() throws IOException {
        this.open(null);
    }

    @Override
    public void open(StructLike newPartitionKey) throws IOException {
        this.partitionKey = newPartitionKey;
        Path path = new Path(this.table.location(), this.generateFilename());
        String location = this.locationProvider.newDataLocation(path.toString());
        logger.info("opening new {} file appender {}", (Object)this.format, (Object)location);
        this.file = this.table.io().newOutputFile(path.toString());
        switch (this.format) {
            case PARQUET: {
                this.appender = Parquet.write((OutputFile)this.file).schema(this.table.schema()).createWriterFunc(GenericParquetWriter::buildWriter).setAll(this.tableProperties).overwrite().build();
                this.lowWatermark = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot write using an unsupported file format " + this.format);
            }
        }
    }

    @Override
    public void write(MantisRecord record) {
        this.appender.add((Object)record.getRecord());
        this.lowWatermark = DefaultIcebergWriter.minNullSafe(this.lowWatermark, record.getTimestamp());
    }

    @Override
    public MantisDataFile close() throws IOException, UncheckedIOException {
        if (this.isClosed()) {
            return null;
        }
        try {
            this.appender.close();
            DataFile dataFile = DataFiles.builder((PartitionSpec)this.spec).withPath(this.file.location()).withInputFile(this.file.toInputFile()).withFileSizeInBytes(this.appender.length()).withPartition(this.spec.fields().size() == 0 ? null : this.partitionKey).withMetrics(this.appender.metrics()).withSplitOffsets(this.appender.splitOffsets()).build();
            MantisDataFile mantisDataFile = new MantisDataFile(dataFile, this.lowWatermark);
            return mantisDataFile;
        }
        finally {
            this.appender = null;
            this.file = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.appender == null;
    }

    @Override
    public long length() throws UncheckedIOException {
        return this.appender == null ? 0L : this.appender.length();
    }

    @Override
    public StructLike getPartitionKey() {
        return this.partitionKey;
    }

    private String generateFilename() {
        return this.generateDataPath(this.generatePartitionPath(this.format.addExtension(String.format("%s_%s_%s_%s_%s", this.workerInfo.getJobId(), this.workerInfo.getStageNumber(), this.workerInfo.getWorkerIndex(), this.workerInfo.getWorkerNumber(), UUID.randomUUID()))));
    }

    private String generateDataPath(String partitionPath) {
        return String.format("data/%s", partitionPath);
    }

    private String generatePartitionPath(String filename) {
        if (this.spec.isUnpartitioned()) {
            return filename;
        }
        return String.format("/%s/%s", this.spec.partitionToPath(this.partitionKey), filename);
    }

    public static Long minNullSafe(@Nullable Long v1, @Nullable Long v2) {
        return DefaultIcebergWriter.compareNullSafe(v1, v2, Math::min);
    }

    public static Long maxNullSafe(@Nullable Long v1, @Nullable Long v2) {
        return DefaultIcebergWriter.compareNullSafe(v1, v2, Math::max);
    }

    private static Long compareNullSafe(@Nullable Long v1, @Nullable Long v2, BiFunction<Long, Long, Long> comparator) {
        if (v1 != null && v2 != null) {
            return comparator.apply(v1, v2);
        }
        if (v1 != null) {
            return v1;
        }
        return v2;
    }
}

