/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.config.PropertySetterException;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.OptionHandler;

public class PropertySetter {
    protected Object obj;
    protected PropertyDescriptor[] props;
    static /* synthetic */ Class class$org$apache$log4j$spi$OptionHandler;

    public PropertySetter(Object obj) {
        this.obj = obj;
    }

    protected void introspect() {
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.obj.getClass());
            this.props = bi.getPropertyDescriptors();
        }
        catch (IntrospectionException ex) {
            LogLog.error("Failed to introspect " + this.obj + ": " + ex.getMessage());
            this.props = new PropertyDescriptor[0];
        }
    }

    public static void setProperties(Object obj, Properties properties2, String prefix) {
        new PropertySetter(obj).setProperties(properties2, prefix);
    }

    public void setProperties(Properties properties2, String prefix) {
        int len = prefix.length();
        Enumeration<?> e2 = properties2.propertyNames();
        while (e2.hasMoreElements()) {
            String key2 = (String)e2.nextElement();
            if (!key2.startsWith(prefix) || key2.indexOf(46, len + 1) > 0) continue;
            String value = OptionConverter.findAndSubst(key2, properties2);
            if (("layout".equals(key2 = key2.substring(len)) || "errorhandler".equals(key2)) && this.obj instanceof Appender) continue;
            PropertyDescriptor prop = this.getPropertyDescriptor(Introspector.decapitalize(key2));
            if (prop != null && (class$org$apache$log4j$spi$OptionHandler == null ? PropertySetter.class$("org.apache.log4j.spi.OptionHandler") : class$org$apache$log4j$spi$OptionHandler).isAssignableFrom(prop.getPropertyType()) && prop.getWriteMethod() != null) {
                OptionHandler opt2 = (OptionHandler)OptionConverter.instantiateByKey(properties2, prefix + key2, prop.getPropertyType(), null);
                PropertySetter setter = new PropertySetter(opt2);
                setter.setProperties(properties2, prefix + key2 + ".");
                try {
                    prop.getWriteMethod().invoke(this.obj, opt2);
                }
                catch (IllegalAccessException ex) {
                    LogLog.warn("Failed to set property [" + key2 + "] to value \"" + value + "\". ", ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof InterruptedException || ex.getTargetException() instanceof InterruptedIOException) {
                        Thread.currentThread().interrupt();
                    }
                    LogLog.warn("Failed to set property [" + key2 + "] to value \"" + value + "\". ", ex);
                }
                catch (RuntimeException ex) {
                    LogLog.warn("Failed to set property [" + key2 + "] to value \"" + value + "\". ", ex);
                }
                continue;
            }
            this.setProperty(key2, value);
        }
        this.activate();
    }

    public void setProperty(String name2, String value) {
        if (value == null) {
            return;
        }
        PropertyDescriptor prop = this.getPropertyDescriptor(name2 = Introspector.decapitalize(name2));
        if (prop == null) {
            LogLog.warn("No such property [" + name2 + "] in " + this.obj.getClass().getName() + ".");
        } else {
            try {
                this.setProperty(prop, name2, value);
            }
            catch (PropertySetterException ex) {
                LogLog.warn("Failed to set property [" + name2 + "] to value \"" + value + "\". ", ex.rootCause);
            }
        }
    }

    public void setProperty(PropertyDescriptor prop, String name2, String value) throws PropertySetterException {
        Object arg;
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            throw new PropertySetterException("No setter for property [" + name2 + "].");
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        if (paramTypes.length != 1) {
            throw new PropertySetterException("#params for setter != 1");
        }
        try {
            arg = this.convertArg(value, paramTypes[0]);
        }
        catch (Throwable t) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed. Reason: " + t);
        }
        if (arg == null) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed.");
        }
        LogLog.debug("Setting property [" + name2 + "] to [" + arg + "].");
        try {
            setter.invoke(this.obj, arg);
        }
        catch (IllegalAccessException ex) {
            throw new PropertySetterException(ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof InterruptedException || ex.getTargetException() instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            throw new PropertySetterException(ex);
        }
        catch (RuntimeException ex) {
            throw new PropertySetterException(ex);
        }
    }

    protected Object convertArg(String val2, Class type2) {
        if (val2 == null) {
            return null;
        }
        String v = val2.trim();
        if (String.class.isAssignableFrom(type2)) {
            return val2;
        }
        if (Integer.TYPE.isAssignableFrom(type2)) {
            return new Integer(v);
        }
        if (Long.TYPE.isAssignableFrom(type2)) {
            return new Long(v);
        }
        if (Boolean.TYPE.isAssignableFrom(type2)) {
            if ("true".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
        } else {
            if (Priority.class.isAssignableFrom(type2)) {
                return OptionConverter.toLevel(v, Level.DEBUG);
            }
            if (ErrorHandler.class.isAssignableFrom(type2)) {
                return OptionConverter.instantiateByClassName(v, ErrorHandler.class, null);
            }
        }
        return null;
    }

    protected PropertyDescriptor getPropertyDescriptor(String name2) {
        if (this.props == null) {
            this.introspect();
        }
        for (int i = 0; i < this.props.length; ++i) {
            if (!name2.equals(this.props[i].getName())) continue;
            return this.props[i];
        }
        return null;
    }

    public void activate() {
        if (this.obj instanceof OptionHandler) {
            ((OptionHandler)this.obj).activateOptions();
        }
    }
}

