/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.channel.socket;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelException;
import io.mantisrx.shaded.org.jboss.netty.channel.DefaultChannelConfig;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.SocketChannelConfig;
import io.mantisrx.shaded.org.jboss.netty.util.internal.ConversionUtil;
import java.net.Socket;
import java.net.SocketException;

public class DefaultSocketChannelConfig
extends DefaultChannelConfig
implements SocketChannelConfig {
    private final Socket socket;

    public DefaultSocketChannelConfig(Socket socket) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        this.socket = socket;
    }

    public boolean setOption(String key2, Object value) {
        if (super.setOption(key2, value)) {
            return true;
        }
        if ("receiveBufferSize".equals(key2)) {
            this.setReceiveBufferSize(ConversionUtil.toInt(value));
        } else if ("sendBufferSize".equals(key2)) {
            this.setSendBufferSize(ConversionUtil.toInt(value));
        } else if ("tcpNoDelay".equals(key2)) {
            this.setTcpNoDelay(ConversionUtil.toBoolean(value));
        } else if ("keepAlive".equals(key2)) {
            this.setKeepAlive(ConversionUtil.toBoolean(value));
        } else if ("reuseAddress".equals(key2)) {
            this.setReuseAddress(ConversionUtil.toBoolean(value));
        } else if ("soLinger".equals(key2)) {
            this.setSoLinger(ConversionUtil.toInt(value));
        } else if ("trafficClass".equals(key2)) {
            this.setTrafficClass(ConversionUtil.toInt(value));
        } else {
            return false;
        }
        return true;
    }

    public int getReceiveBufferSize() {
        try {
            return this.socket.getReceiveBufferSize();
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public int getSendBufferSize() {
        try {
            return this.socket.getSendBufferSize();
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public int getSoLinger() {
        try {
            return this.socket.getSoLinger();
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public int getTrafficClass() {
        try {
            return this.socket.getTrafficClass();
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public boolean isKeepAlive() {
        try {
            return this.socket.getKeepAlive();
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public boolean isReuseAddress() {
        try {
            return this.socket.getReuseAddress();
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public boolean isTcpNoDelay() {
        try {
            return this.socket.getTcpNoDelay();
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public void setKeepAlive(boolean keepAlive) {
        try {
            this.socket.setKeepAlive(keepAlive);
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.socket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        try {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public void setReuseAddress(boolean reuseAddress) {
        try {
            this.socket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public void setSendBufferSize(int sendBufferSize) {
        try {
            this.socket.setSendBufferSize(sendBufferSize);
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public void setSoLinger(int soLinger) {
        try {
            if (soLinger < 0) {
                this.socket.setSoLinger(false, 0);
            } else {
                this.socket.setSoLinger(true, soLinger);
            }
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        try {
            this.socket.setTcpNoDelay(tcpNoDelay);
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }

    public void setTrafficClass(int trafficClass) {
        try {
            this.socket.setTrafficClass(trafficClass);
        }
        catch (SocketException e2) {
            throw new ChannelException(e2);
        }
    }
}

