/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.buffer;

import io.mantisrx.shaded.org.jboss.netty.buffer.AbstractChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBufferFactory;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffers;
import io.mantisrx.shaded.org.jboss.netty.buffer.DirectChannelBufferFactory;
import io.mantisrx.shaded.org.jboss.netty.buffer.HeapChannelBufferFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class ByteBufferBackedChannelBuffer
extends AbstractChannelBuffer {
    private final ByteBuffer buffer;
    private final ByteOrder order;
    private final int capacity;

    public ByteBufferBackedChannelBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        this.order = buffer.order();
        this.buffer = buffer.slice().order(this.order);
        this.capacity = buffer.remaining();
        this.writerIndex(this.capacity);
    }

    private ByteBufferBackedChannelBuffer(ByteBufferBackedChannelBuffer buffer) {
        this.buffer = buffer.buffer;
        this.order = buffer.order;
        this.capacity = buffer.capacity;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    public ChannelBufferFactory factory() {
        if (this.buffer.isDirect()) {
            return DirectChannelBufferFactory.getInstance(this.order());
        }
        return HeapChannelBufferFactory.getInstance(this.order());
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public ByteOrder order() {
        return this.order;
    }

    public int capacity() {
        return this.capacity;
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public byte getByte(int index2) {
        return this.buffer.get(index2);
    }

    public short getShort(int index2) {
        return this.buffer.getShort(index2);
    }

    public int getUnsignedMedium(int index2) {
        return (this.getByte(index2) & 0xFF) << 16 | (this.getByte(index2 + 1) & 0xFF) << 8 | this.getByte(index2 + 2) & 0xFF;
    }

    public int getInt(int index2) {
        return this.buffer.getInt(index2);
    }

    public long getLong(int index2) {
        return this.buffer.getLong(index2);
    }

    public void getBytes(int index2, ChannelBuffer dst, int dstIndex, int length) {
        if (dst instanceof ByteBufferBackedChannelBuffer) {
            ByteBufferBackedChannelBuffer bbdst = (ByteBufferBackedChannelBuffer)dst;
            ByteBuffer data2 = bbdst.buffer.duplicate();
            data2.limit(dstIndex + length).position(dstIndex);
            this.getBytes(index2, data2);
        } else if (this.buffer.hasArray()) {
            dst.setBytes(dstIndex, this.buffer.array(), index2 + this.buffer.arrayOffset(), length);
        } else {
            dst.setBytes(dstIndex, this, index2, length);
        }
    }

    public void getBytes(int index2, byte[] dst, int dstIndex, int length) {
        ByteBuffer data2 = this.buffer.duplicate();
        try {
            data2.limit(index2 + length).position(index2);
        }
        catch (IllegalArgumentException e2) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index2 + length) + ", maximum is " + data2.limit());
        }
        data2.get(dst, dstIndex, length);
    }

    public void getBytes(int index2, ByteBuffer dst) {
        ByteBuffer data2 = this.buffer.duplicate();
        int bytesToCopy = Math.min(this.capacity() - index2, dst.remaining());
        try {
            data2.limit(index2 + bytesToCopy).position(index2);
        }
        catch (IllegalArgumentException e2) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index2 + bytesToCopy) + ", maximum is " + data2.limit());
        }
        dst.put(data2);
    }

    public void setByte(int index2, int value) {
        this.buffer.put(index2, (byte)value);
    }

    public void setShort(int index2, int value) {
        this.buffer.putShort(index2, (short)value);
    }

    public void setMedium(int index2, int value) {
        this.setByte(index2, (byte)(value >>> 16));
        this.setByte(index2 + 1, (byte)(value >>> 8));
        this.setByte(index2 + 2, (byte)value);
    }

    public void setInt(int index2, int value) {
        this.buffer.putInt(index2, value);
    }

    public void setLong(int index2, long value) {
        this.buffer.putLong(index2, value);
    }

    public void setBytes(int index2, ChannelBuffer src, int srcIndex, int length) {
        if (src instanceof ByteBufferBackedChannelBuffer) {
            ByteBufferBackedChannelBuffer bbsrc = (ByteBufferBackedChannelBuffer)src;
            ByteBuffer data2 = bbsrc.buffer.duplicate();
            data2.limit(srcIndex + length).position(srcIndex);
            this.setBytes(index2, data2);
        } else if (this.buffer.hasArray()) {
            src.getBytes(srcIndex, this.buffer.array(), index2 + this.buffer.arrayOffset(), length);
        } else {
            src.getBytes(srcIndex, this, index2, length);
        }
    }

    public void setBytes(int index2, byte[] src, int srcIndex, int length) {
        ByteBuffer data2 = this.buffer.duplicate();
        data2.limit(index2 + length).position(index2);
        data2.put(src, srcIndex, length);
    }

    public void setBytes(int index2, ByteBuffer src) {
        ByteBuffer data2 = this.buffer.duplicate();
        data2.limit(index2 + src.remaining()).position(index2);
        data2.put(src);
    }

    public void getBytes(int index2, OutputStream out, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), index2 + this.buffer.arrayOffset(), length);
        } else {
            byte[] tmp = new byte[length];
            ((ByteBuffer)this.buffer.duplicate().position(index2)).get(tmp);
            out.write(tmp);
        }
    }

    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        return out.write((ByteBuffer)this.buffer.duplicate().position(index2).limit(index2 + length));
    }

    public int setBytes(int index2, InputStream in, int length) throws IOException {
        int readBytes = 0;
        if (this.buffer.hasArray()) {
            int localReadBytes;
            index2 += this.buffer.arrayOffset();
            do {
                if ((localReadBytes = in.read(this.buffer.array(), index2, length)) < 0) {
                    if (readBytes == 0) {
                        return -1;
                    }
                    break;
                }
                readBytes += localReadBytes;
                index2 += localReadBytes;
            } while ((length -= localReadBytes) > 0);
        } else {
            int localReadBytes;
            byte[] tmp = new byte[length];
            int i = 0;
            do {
                if ((localReadBytes = in.read(tmp, i, tmp.length - i)) >= 0) continue;
                if (readBytes != 0) break;
                return -1;
            } while ((i += (readBytes += localReadBytes)) < tmp.length);
            ((ByteBuffer)this.buffer.duplicate().position(index2)).put(tmp);
        }
        return readBytes;
    }

    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        int readBytes;
        int localReadBytes;
        ByteBuffer slice = (ByteBuffer)this.buffer.duplicate().limit(index2 + length).position(index2);
        for (readBytes = 0; readBytes < length; readBytes += localReadBytes) {
            try {
                localReadBytes = in.read(slice);
            }
            catch (ClosedChannelException e2) {
                localReadBytes = -1;
            }
            if (localReadBytes < 0) {
                if (readBytes == 0) {
                    return -1;
                }
                return readBytes;
            }
            if (localReadBytes == 0) break;
        }
        return readBytes;
    }

    public ByteBuffer toByteBuffer(int index2, int length) {
        if (index2 == 0 && length == this.capacity()) {
            return this.buffer.duplicate().order(this.order());
        }
        return ((ByteBuffer)this.buffer.duplicate().position(index2).limit(index2 + length)).slice().order(this.order());
    }

    public ChannelBuffer slice(int index2, int length) {
        if (index2 == 0 && length == this.capacity()) {
            ChannelBuffer slice = this.duplicate();
            slice.setIndex(0, length);
            return slice;
        }
        if (index2 >= 0 && length == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return new ByteBufferBackedChannelBuffer(((ByteBuffer)this.buffer.duplicate().position(index2).limit(index2 + length)).order(this.order()));
    }

    public ChannelBuffer duplicate() {
        return new ByteBufferBackedChannelBuffer(this);
    }

    public ChannelBuffer copy(int index2, int length) {
        ByteBuffer src;
        try {
            src = (ByteBuffer)this.buffer.duplicate().position(index2).limit(index2 + length);
        }
        catch (IllegalArgumentException e2) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index2 + length));
        }
        ByteBuffer dst = this.buffer.isDirect() ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        dst.put(src);
        dst.order(this.order());
        dst.clear();
        return new ByteBufferBackedChannelBuffer(dst);
    }
}

