/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.jute.InputArchive;
import io.mantisrx.shaded.org.apache.jute.OutputArchive;
import io.mantisrx.shaded.org.apache.jute.Record;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.Quotas;
import io.mantisrx.shaded.org.apache.zookeeper.StatsTrack;
import io.mantisrx.shaded.org.apache.zookeeper.WatchedEvent;
import io.mantisrx.shaded.org.apache.zookeeper.Watcher;
import io.mantisrx.shaded.org.apache.zookeeper.common.PathTrie;
import io.mantisrx.shaded.org.apache.zookeeper.data.ACL;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import io.mantisrx.shaded.org.apache.zookeeper.data.StatPersisted;
import io.mantisrx.shaded.org.apache.zookeeper.server.ByteBufferInputStream;
import io.mantisrx.shaded.org.apache.zookeeper.server.DataNode;
import io.mantisrx.shaded.org.apache.zookeeper.server.ReferenceCountedACLCache;
import io.mantisrx.shaded.org.apache.zookeeper.server.WatchManager;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooTrace;
import io.mantisrx.shaded.org.apache.zookeeper.server.upgrade.DataNodeV1;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CheckVersionTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.DeleteTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.ErrorTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.MultiTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.SetACLTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.SetDataTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.Txn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTree {
    private static final Logger LOG = LoggerFactory.getLogger(DataTree.class);
    private final ConcurrentHashMap<String, DataNode> nodes = new ConcurrentHashMap();
    private final WatchManager dataWatches = new WatchManager();
    private final WatchManager childWatches = new WatchManager();
    private static final String rootZookeeper = "/";
    private static final String procZookeeper = "/zookeeper";
    private static final String procChildZookeeper = "/zookeeper".substring(1);
    private static final String quotaZookeeper = "/zookeeper/quota";
    private static final String quotaChildZookeeper = "/zookeeper/quota".substring("/zookeeper".length() + 1);
    private final PathTrie pTrie = new PathTrie();
    private final Map<Long, HashSet<String>> ephemerals = new ConcurrentHashMap<Long, HashSet<String>>();
    private final ReferenceCountedACLCache aclCache = new ReferenceCountedACLCache();
    private DataNode root = new DataNode(null, new byte[0], -1L, new StatPersisted());
    private DataNode procDataNode = new DataNode(this.root, new byte[0], -1L, new StatPersisted());
    private DataNode quotaDataNode = new DataNode(this.procDataNode, new byte[0], -1L, new StatPersisted());
    public volatile long lastProcessedZxid = 0L;
    int scount;
    public boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> getEphemerals(long sessionId) {
        HashSet<String> retv = this.ephemerals.get(sessionId);
        if (retv == null) {
            return new HashSet<String>();
        }
        HashSet cloned = null;
        HashSet<String> hashSet = retv;
        synchronized (hashSet) {
            cloned = (HashSet)retv.clone();
        }
        return cloned;
    }

    public Map<Long, HashSet<String>> getEphemeralsMap() {
        return this.ephemerals;
    }

    public Collection<Long> getSessions() {
        return this.ephemerals.keySet();
    }

    public void addDataNode(String path2, DataNode node2) {
        this.nodes.put(path2, node2);
    }

    public DataNode getNode(String path2) {
        return this.nodes.get(path2);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getWatchCount() {
        return this.dataWatches.size() + this.childWatches.size();
    }

    public int getEphemeralsCount() {
        Map<Long, HashSet<String>> map2 = this.getEphemeralsMap();
        int result = 0;
        for (HashSet<String> set2 : map2.values()) {
            result += set2.size();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long approximateDataSize() {
        long result = 0L;
        for (Map.Entry<String, DataNode> entry : this.nodes.entrySet()) {
            DataNode value;
            DataNode dataNode = value = entry.getValue();
            synchronized (dataNode) {
                result += (long)entry.getKey().length();
                result += (long)(value.data == null ? 0 : value.data.length);
            }
        }
        return result;
    }

    public DataTree() {
        this.nodes.put("", this.root);
        this.nodes.put(rootZookeeper, this.root);
        this.root.addChild(procChildZookeeper);
        this.nodes.put(procZookeeper, this.procDataNode);
        this.procDataNode.addChild(quotaChildZookeeper);
        this.nodes.put(quotaZookeeper, this.quotaDataNode);
    }

    boolean isSpecialPath(String path2) {
        return rootZookeeper.equals(path2) || procZookeeper.equals(path2) || quotaZookeeper.equals(path2);
    }

    public static void copyStatPersisted(StatPersisted from, StatPersisted to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setPzxid(from.getPzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
    }

    public static void copyStat(Stat from, Stat to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setPzxid(from.getPzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
        to.setDataLength(from.getDataLength());
        to.setNumChildren(from.getNumChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCount(String lastPrefix, int diff2) {
        String statNode = Quotas.statPath(lastPrefix);
        DataNode node2 = this.nodes.get(statNode);
        StatsTrack updatedStat = null;
        if (node2 == null) {
            LOG.error("Missing count node for stat " + statNode);
            return;
        }
        DataNode dataNode = node2;
        synchronized (dataNode) {
            updatedStat = new StatsTrack(new String(node2.data));
            updatedStat.setCount(updatedStat.getCount() + diff2);
            node2.data = updatedStat.toString().getBytes();
        }
        String quotaNode = Quotas.quotaPath(lastPrefix);
        node2 = this.nodes.get(quotaNode);
        StatsTrack thisStats = null;
        if (node2 == null) {
            LOG.error("Missing count node for quota " + quotaNode);
            return;
        }
        DataNode dataNode2 = node2;
        synchronized (dataNode2) {
            thisStats = new StatsTrack(new String(node2.data));
        }
        if (thisStats.getCount() > -1 && thisStats.getCount() < updatedStat.getCount()) {
            LOG.warn("Quota exceeded: " + lastPrefix + " count=" + updatedStat.getCount() + " limit=" + thisStats.getCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBytes(String lastPrefix, long diff2) {
        String statNode = Quotas.statPath(lastPrefix);
        DataNode node2 = this.nodes.get(statNode);
        if (node2 == null) {
            LOG.error("Missing stat node for bytes " + statNode);
            return;
        }
        StatsTrack updatedStat = null;
        DataNode dataNode = node2;
        synchronized (dataNode) {
            updatedStat = new StatsTrack(new String(node2.data));
            updatedStat.setBytes(updatedStat.getBytes() + diff2);
            node2.data = updatedStat.toString().getBytes();
        }
        String quotaNode = Quotas.quotaPath(lastPrefix);
        node2 = this.nodes.get(quotaNode);
        if (node2 == null) {
            LOG.error("Missing quota node for bytes " + quotaNode);
            return;
        }
        StatsTrack thisStats = null;
        DataNode dataNode2 = node2;
        synchronized (dataNode2) {
            thisStats = new StatsTrack(new String(node2.data));
        }
        if (thisStats.getBytes() > -1L && thisStats.getBytes() < updatedStat.getBytes()) {
            LOG.warn("Quota exceeded: " + lastPrefix + " bytes=" + updatedStat.getBytes() + " limit=" + thisStats.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNode(String path2, byte[] data2, List<ACL> acl, long ephemeralOwner, int parentCVersion, long zxid, long time2) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        String lastPrefix;
        int lastSlash = path2.lastIndexOf(47);
        String parentName = path2.substring(0, lastSlash);
        String childName = path2.substring(lastSlash + 1);
        StatPersisted stat = new StatPersisted();
        stat.setCtime(time2);
        stat.setMtime(time2);
        stat.setCzxid(zxid);
        stat.setMzxid(zxid);
        stat.setPzxid(zxid);
        stat.setVersion(0);
        stat.setAversion(0);
        stat.setEphemeralOwner(ephemeralOwner);
        DataNode parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = parent;
        synchronized (dataNode) {
            Set<String> children2 = parent.getChildren();
            if (children2.contains(childName)) {
                throw new KeeperException.NodeExistsException();
            }
            if (parentCVersion == -1) {
                parentCVersion = parent.stat.getCversion();
                ++parentCVersion;
            }
            parent.stat.setCversion(parentCVersion);
            parent.stat.setPzxid(zxid);
            Long longval = this.aclCache.convertAcls(acl);
            DataNode child = new DataNode(parent, data2, longval, stat);
            parent.addChild(childName);
            this.nodes.put(path2, child);
            if (ephemeralOwner != 0L) {
                HashSet<String> list = this.ephemerals.get(ephemeralOwner);
                if (list == null) {
                    list = new HashSet();
                    this.ephemerals.put(ephemeralOwner, list);
                }
                HashSet<String> hashSet = list;
                synchronized (hashSet) {
                    list.add(path2);
                }
            }
        }
        if (parentName.startsWith(quotaZookeeper)) {
            if ("zookeeper_limits".equals(childName)) {
                this.pTrie.addPath(parentName.substring(quotaZookeeper.length()));
            }
            if ("zookeeper_stats".equals(childName)) {
                this.updateQuotaForPath(parentName.substring(quotaZookeeper.length()));
            }
        }
        if ((lastPrefix = this.getMaxPrefixWithQuota(path2)) != null) {
            this.updateCount(lastPrefix, 1);
            this.updateBytes(lastPrefix, data2 == null ? 0L : (long)data2.length);
        }
        this.dataWatches.triggerWatch(path2, Watcher.Event.EventType.NodeCreated);
        this.childWatches.triggerWatch(parentName.equals("") ? rootZookeeper : parentName, Watcher.Event.EventType.NodeChildrenChanged);
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(String path2, long zxid) throws KeeperException.NoNodeException {
        String lastPrefix;
        int lastSlash = path2.lastIndexOf(47);
        String parentName = path2.substring(0, lastSlash);
        String childName = path2.substring(lastSlash + 1);
        DataNode node2 = this.nodes.get(path2);
        if (node2 == null) {
            throw new KeeperException.NoNodeException();
        }
        this.nodes.remove(path2);
        DataNode dataNode = node2;
        synchronized (dataNode) {
            this.aclCache.removeUsage(node2.acl);
        }
        DataNode parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode2 = parent;
        synchronized (dataNode2) {
            HashSet<String> nodes;
            parent.removeChild(childName);
            parent.stat.setPzxid(zxid);
            long eowner = node2.stat.getEphemeralOwner();
            if (eowner != 0L && (nodes = this.ephemerals.get(eowner)) != null) {
                HashSet<String> hashSet = nodes;
                synchronized (hashSet) {
                    nodes.remove(path2);
                }
            }
            node2.parent = null;
        }
        if (parentName.startsWith(procZookeeper) && "zookeeper_limits".equals(childName)) {
            this.pTrie.deletePath(parentName.substring(quotaZookeeper.length()));
        }
        if ((lastPrefix = this.getMaxPrefixWithQuota(path2)) != null) {
            this.updateCount(lastPrefix, -1);
            int bytes2 = 0;
            DataNode dataNode3 = node2;
            synchronized (dataNode3) {
                bytes2 = node2.data == null ? 0 : -node2.data.length;
            }
            this.updateBytes(lastPrefix, bytes2);
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 64L, "dataWatches.triggerWatch " + path2);
            ZooTrace.logTraceMessage(LOG, 64L, "childWatches.triggerWatch " + parentName);
        }
        Set<Watcher> processed = this.dataWatches.triggerWatch(path2, Watcher.Event.EventType.NodeDeleted);
        this.childWatches.triggerWatch(path2, Watcher.Event.EventType.NodeDeleted, processed);
        this.childWatches.triggerWatch(parentName.equals("") ? rootZookeeper : parentName, Watcher.Event.EventType.NodeChildrenChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setData(String path2, byte[] data2, int version, long zxid, long time2) throws KeeperException.NoNodeException {
        Stat s = new Stat();
        DataNode n = this.nodes.get(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        byte[] lastdata = null;
        DataNode dataNode = n;
        synchronized (dataNode) {
            lastdata = n.data;
            n.data = data2;
            n.stat.setMtime(time2);
            n.stat.setMzxid(zxid);
            n.stat.setVersion(version);
            n.copyStat(s);
        }
        String lastPrefix = this.getMaxPrefixWithQuota(path2);
        if (lastPrefix != null) {
            this.updateBytes(lastPrefix, (data2 == null ? 0 : data2.length) - (lastdata == null ? 0 : lastdata.length));
        }
        this.dataWatches.triggerWatch(path2, Watcher.Event.EventType.NodeDataChanged);
        return s;
    }

    public String getMaxPrefixWithQuota(String path2) {
        String lastPrefix = this.pTrie.findMaxPrefix(path2);
        if (!rootZookeeper.equals(lastPrefix) && !"".equals(lastPrefix)) {
            return lastPrefix;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String path2, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
            if (watcher != null) {
                this.dataWatches.addWatch(path2, watcher);
            }
            return n.data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat statNode(String path2, Watcher watcher) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        DataNode n = this.nodes.get(path2);
        if (watcher != null) {
            this.dataWatches.addWatch(path2, watcher);
        }
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path2, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            if (stat != null) {
                n.copyStat(stat);
            }
            ArrayList<String> children2 = new ArrayList<String>(n.getChildren());
            if (watcher != null) {
                this.childWatches.addWatch(path2, watcher);
            }
            return children2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setACL(String path2, List<ACL> acl, int version) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        DataNode n = this.nodes.get(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            this.aclCache.removeUsage(n.acl);
            n.stat.setAversion(version);
            n.acl = this.aclCache.convertAcls(acl);
            n.copyStat(stat);
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(String path2, Stat stat) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path2);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
            return new ArrayList<ACL>(this.aclCache.convertLong(n.acl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(DataNode node2) {
        DataNode dataNode = node2;
        synchronized (dataNode) {
            return this.aclCache.convertLong(node2.acl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getACL(DataNodeV1 oldDataNode) {
        DataNodeV1 dataNodeV1 = oldDataNode;
        synchronized (dataNodeV1) {
            return this.aclCache.convertAcls(oldDataNode.acl);
        }
    }

    public int aclCacheSize() {
        return this.aclCache.size();
    }

    public ProcessTxnResult processTxn(TxnHeader header, Record txn) {
        ProcessTxnResult rc;
        block32: {
            rc = new ProcessTxnResult();
            try {
                rc.clientId = header.getClientId();
                rc.cxid = header.getCxid();
                rc.zxid = header.getZxid();
                rc.type = header.getType();
                rc.err = 0;
                rc.multiResult = null;
                switch (header.getType()) {
                    case 1: {
                        CreateTxn createTxn = (CreateTxn)txn;
                        rc.path = createTxn.getPath();
                        this.createNode(createTxn.getPath(), createTxn.getData(), createTxn.getAcl(), createTxn.getEphemeral() ? header.getClientId() : 0L, createTxn.getParentCVersion(), header.getZxid(), header.getTime());
                        break;
                    }
                    case 2: {
                        DeleteTxn deleteTxn = (DeleteTxn)txn;
                        rc.path = deleteTxn.getPath();
                        this.deleteNode(deleteTxn.getPath(), header.getZxid());
                        break;
                    }
                    case 5: {
                        SetDataTxn setDataTxn = (SetDataTxn)txn;
                        rc.path = setDataTxn.getPath();
                        rc.stat = this.setData(setDataTxn.getPath(), setDataTxn.getData(), setDataTxn.getVersion(), header.getZxid(), header.getTime());
                        break;
                    }
                    case 7: {
                        SetACLTxn setACLTxn = (SetACLTxn)txn;
                        rc.path = setACLTxn.getPath();
                        rc.stat = this.setACL(setACLTxn.getPath(), setACLTxn.getAcl(), setACLTxn.getVersion());
                        break;
                    }
                    case -11: {
                        this.killSession(header.getClientId(), header.getZxid());
                        break;
                    }
                    case -1: {
                        ErrorTxn errTxn = (ErrorTxn)txn;
                        rc.err = errTxn.getErr();
                        break;
                    }
                    case 13: {
                        CheckVersionTxn checkTxn = (CheckVersionTxn)txn;
                        rc.path = checkTxn.getPath();
                        break;
                    }
                    case 14: {
                        MultiTxn multiTxn = (MultiTxn)txn;
                        List<Txn> txns = multiTxn.getTxns();
                        rc.multiResult = new ArrayList<ProcessTxnResult>();
                        boolean failed = false;
                        for (Txn subtxn : txns) {
                            if (subtxn.getType() != -1) continue;
                            failed = true;
                            break;
                        }
                        boolean post_failed = false;
                        for (Txn subtxn : txns) {
                            ByteBuffer bb = ByteBuffer.wrap(subtxn.getData());
                            Record record = null;
                            switch (subtxn.getType()) {
                                case 1: {
                                    record = new CreateTxn();
                                    break;
                                }
                                case 2: {
                                    record = new DeleteTxn();
                                    break;
                                }
                                case 5: {
                                    record = new SetDataTxn();
                                    break;
                                }
                                case -1: {
                                    record = new ErrorTxn();
                                    post_failed = true;
                                    break;
                                }
                                case 13: {
                                    record = new CheckVersionTxn();
                                    break;
                                }
                                default: {
                                    throw new IOException("Invalid type of op: " + subtxn.getType());
                                }
                            }
                            assert (record != null);
                            ByteBufferInputStream.byteBuffer2Record(bb, record);
                            if (failed && subtxn.getType() != -1) {
                                int ec = post_failed ? KeeperException.Code.RUNTIMEINCONSISTENCY.intValue() : KeeperException.Code.OK.intValue();
                                subtxn.setType(-1);
                                record = new ErrorTxn(ec);
                            }
                            if (failed) assert (subtxn.getType() == -1);
                            TxnHeader subHdr = new TxnHeader(header.getClientId(), header.getCxid(), header.getZxid(), header.getTime(), subtxn.getType());
                            ProcessTxnResult subRc = this.processTxn(subHdr, record);
                            rc.multiResult.add(subRc);
                            if (subRc.err == 0 || rc.err != 0) continue;
                            rc.err = subRc.err;
                        }
                        break;
                    }
                }
            }
            catch (KeeperException e2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed: " + header + ":" + txn, e2);
                }
                rc.err = e2.code().intValue();
            }
            catch (IOException e3) {
                if (!LOG.isDebugEnabled()) break block32;
                LOG.debug("Failed: " + header + ":" + txn, e3);
            }
        }
        if (rc.zxid > this.lastProcessedZxid) {
            this.lastProcessedZxid = rc.zxid;
        }
        if (header.getType() == 1 && rc.err == KeeperException.Code.NODEEXISTS.intValue()) {
            LOG.debug("Adjusting parent cversion for Txn: " + header.getType() + " path:" + rc.path + " err: " + rc.err);
            int lastSlash = rc.path.lastIndexOf(47);
            String parentName = rc.path.substring(0, lastSlash);
            CreateTxn cTxn = (CreateTxn)txn;
            try {
                this.setCversionPzxid(parentName, cTxn.getParentCVersion(), header.getZxid());
            }
            catch (KeeperException.NoNodeException e4) {
                LOG.error("Failed to set parent cversion for: " + parentName, e4);
                rc.err = e4.code().intValue();
            }
        } else if (rc.err != KeeperException.Code.OK.intValue()) {
            LOG.debug("Ignoring processTxn failure hdr: " + header.getType() + " : error: " + rc.err);
        }
        return rc;
    }

    void killSession(long session, long zxid) {
        HashSet<String> list = this.ephemerals.remove(session);
        if (list != null) {
            for (String path2 : list) {
                try {
                    this.deleteNode(path2, zxid);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Deleting ephemeral node " + path2 + " for session 0x" + Long.toHexString(session));
                }
                catch (KeeperException.NoNodeException e2) {
                    LOG.warn("Ignoring NoNodeException for path " + path2 + " while removing ephemeral for dead session 0x" + Long.toHexString(session));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCounts(String path2, Counts counts) {
        String[] node2 = this.getNode(path2);
        if (node2 == null) {
            return;
        }
        String[] children2 = null;
        int len = 0;
        String[] stringArray = node2;
        synchronized (node2) {
            Set<String> childs = node2.getChildren();
            children2 = childs.toArray(new String[childs.size()]);
            len = node2.data == null ? 0 : node2.data.length;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            ++counts.count;
            counts.bytes += (long)len;
            for (String child : children2) {
                this.getCounts(path2 + rootZookeeper + child, counts);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuotaForPath(String path2) {
        Counts c = new Counts();
        this.getCounts(path2, c);
        StatsTrack strack = new StatsTrack();
        strack.setBytes(c.bytes);
        strack.setCount(c.count);
        String statPath = quotaZookeeper + path2 + rootZookeeper + "zookeeper_stats";
        DataNode node2 = this.getNode(statPath);
        if (node2 == null) {
            LOG.warn("Missing quota stat node " + statPath);
            return;
        }
        DataNode dataNode = node2;
        synchronized (dataNode) {
            node2.data = strack.toString().getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverseNode(String path2) {
        String[] node2 = this.getNode(path2);
        String[] children2 = null;
        String[] stringArray = node2;
        synchronized (node2) {
            Set<String> childs = node2.getChildren();
            children2 = childs.toArray(new String[childs.size()]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (children2.length == 0) {
                String endString = "/zookeeper_limits";
                if (path2.endsWith(endString)) {
                    String realPath = path2.substring(quotaZookeeper.length(), path2.indexOf(endString));
                    this.updateQuotaForPath(realPath);
                    this.pTrie.addPath(realPath);
                }
                return;
            }
            for (String child : children2) {
                this.traverseNode(path2 + rootZookeeper + child);
            }
            return;
        }
    }

    private void setupQuota() {
        String quotaPath = quotaZookeeper;
        DataNode node2 = this.getNode(quotaPath);
        if (node2 == null) {
            return;
        }
        this.traverseNode(quotaPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeNode(OutputArchive oa, StringBuilder path2) throws IOException {
        DataNode nodeCopy;
        String pathString = path2.toString();
        DataNode node2 = this.getNode(pathString);
        if (node2 == null) {
            return;
        }
        String[] children2 = null;
        DataNode dataNode = node2;
        synchronized (dataNode) {
            ++this.scount;
            StatPersisted statCopy = new StatPersisted();
            DataTree.copyStatPersisted(node2.stat, statCopy);
            nodeCopy = new DataNode(node2.parent, node2.data, node2.acl, statCopy);
            Set<String> childs = node2.getChildren();
            children2 = childs.toArray(new String[childs.size()]);
        }
        oa.writeString(pathString, "path");
        oa.writeRecord(nodeCopy, "node");
        path2.append('/');
        int off = path2.length();
        for (String child : children2) {
            path2.delete(off, Integer.MAX_VALUE);
            path2.append(child);
            this.serializeNode(oa, path2);
        }
    }

    public void serialize(OutputArchive oa, String tag) throws IOException {
        this.scount = 0;
        this.aclCache.serialize(oa);
        this.serializeNode(oa, new StringBuilder(""));
        if (this.root != null) {
            oa.writeString(rootZookeeper, "path");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(InputArchive ia, String tag) throws IOException {
        this.aclCache.deserialize(ia);
        this.nodes.clear();
        this.pTrie.clear();
        String path2 = ia.readString("path");
        while (!path2.equals(rootZookeeper)) {
            DataNode node2 = new DataNode();
            ia.readRecord(node2, "node");
            this.nodes.put(path2, node2);
            DataNode dataNode = node2;
            synchronized (dataNode) {
                this.aclCache.addUsage(node2.acl);
            }
            int lastSlash = path2.lastIndexOf(47);
            if (lastSlash == -1) {
                this.root = node2;
            } else {
                String parentPath = path2.substring(0, lastSlash);
                node2.parent = this.nodes.get(parentPath);
                if (node2.parent == null) {
                    throw new IOException("Invalid Datatree, unable to find parent " + parentPath + " of path " + path2);
                }
                node2.parent.addChild(path2.substring(lastSlash + 1));
                long eowner = node2.stat.getEphemeralOwner();
                if (eowner != 0L) {
                    HashSet<String> list = this.ephemerals.get(eowner);
                    if (list == null) {
                        list = new HashSet();
                        this.ephemerals.put(eowner, list);
                    }
                    list.add(path2);
                }
            }
            path2 = ia.readString("path");
        }
        this.nodes.put(rootZookeeper, this.root);
        this.setupQuota();
        this.aclCache.purgeUnused();
    }

    public synchronized void dumpWatchesSummary(PrintWriter pwriter) {
        pwriter.print(this.dataWatches.toString());
    }

    public synchronized void dumpWatches(PrintWriter pwriter, boolean byPath) {
        this.dataWatches.dumpWatches(pwriter, byPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpEphemerals(PrintWriter pwriter) {
        Set<Map.Entry<Long, HashSet<String>>> entrySet = this.ephemerals.entrySet();
        pwriter.println("Sessions with Ephemerals (" + entrySet.size() + "):");
        for (Map.Entry<Long, HashSet<String>> entry : entrySet) {
            pwriter.print("0x" + Long.toHexString(entry.getKey()));
            pwriter.println(":");
            HashSet<String> tmp = entry.getValue();
            if (tmp == null) continue;
            HashSet<String> hashSet = tmp;
            synchronized (hashSet) {
                for (String path2 : tmp) {
                    pwriter.println("\t" + path2);
                }
            }
        }
    }

    public void removeCnxn(Watcher watcher) {
        this.dataWatches.removeWatcher(watcher);
        this.childWatches.removeWatcher(watcher);
    }

    public void clear() {
        this.root = null;
        this.nodes.clear();
        this.ephemerals.clear();
    }

    public void setWatches(long relativeZxid, List<String> dataWatches, List<String> existWatches, List<String> childWatches, Watcher watcher) {
        DataNode node2;
        for (String path2 : dataWatches) {
            node2 = this.getNode(path2);
            if (node2 == null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path2));
                continue;
            }
            if (node2.stat.getMzxid() > relativeZxid) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path2));
                continue;
            }
            this.dataWatches.addWatch(path2, watcher);
        }
        for (String path2 : existWatches) {
            node2 = this.getNode(path2);
            if (node2 != null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, path2));
                continue;
            }
            this.dataWatches.addWatch(path2, watcher);
        }
        for (String path2 : childWatches) {
            node2 = this.getNode(path2);
            if (node2 == null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path2));
                continue;
            }
            if (node2.stat.getPzxid() > relativeZxid) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, path2));
                continue;
            }
            this.childWatches.addWatch(path2, watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCversionPzxid(String path2, int newCversion, long zxid) throws KeeperException.NoNodeException {
        DataNode node2;
        if (path2.endsWith(rootZookeeper)) {
            path2 = path2.substring(0, path2.length() - 1);
        }
        if ((node2 = this.nodes.get(path2)) == null) {
            throw new KeeperException.NoNodeException(path2);
        }
        DataNode dataNode = node2;
        synchronized (dataNode) {
            if (newCversion == -1) {
                newCversion = node2.stat.getCversion() + 1;
            }
            if (newCversion > node2.stat.getCversion()) {
                node2.stat.setCversion(newCversion);
                node2.stat.setPzxid(zxid);
            }
        }
    }

    private static class Counts {
        long bytes;
        int count;

        private Counts() {
        }
    }

    public static class ProcessTxnResult {
        public long clientId;
        public int cxid;
        public long zxid;
        public int err;
        public int type;
        public String path;
        public Stat stat;
        public List<ProcessTxnResult> multiResult;

        public boolean equals(Object o) {
            if (o instanceof ProcessTxnResult) {
                ProcessTxnResult other = (ProcessTxnResult)o;
                return other.clientId == this.clientId && other.cxid == this.cxid;
            }
            return false;
        }

        public int hashCode() {
            return (int)((this.clientId ^ (long)this.cxid) % Integer.MAX_VALUE);
        }
    }
}

