/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.imps;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.api.ErrorListenerPathable;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkState;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FailedDeleteManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    volatile FailedDeleteManagerListener debugListener = null;

    FailedDeleteManager(CuratorFramework client) {
        this.client = client;
    }

    void addFailedDelete(String path2) {
        if (this.debugListener != null) {
            this.debugListener.pathAddedForDelete(path2);
        }
        if (this.client.getState() == CuratorFrameworkState.STARTED) {
            this.log.debug("Path being added to guaranteed delete set: " + path2);
            try {
                ((ErrorListenerPathable)this.client.delete().guaranteed().inBackground()).forPath(path2);
            }
            catch (Exception e2) {
                ThreadUtils.checkInterrupted(e2);
                this.addFailedDelete(path2);
            }
        }
    }

    static interface FailedDeleteManagerListener {
        public void pathAddedForDelete(String var1);
    }
}

