/*
 * Decompiled with CFR 0.152.
 */
package com.mantisrx.common.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOExceptionList;

public class Closeables {
    public static Closeable combine(Collection<? extends Closeable> closeables) {
        return Closeables.combine(closeables.toArray(new Closeable[0]));
    }

    public static Closeable combine(Closeable ... closeables) {
        return () -> {
            ArrayList<Exception> list = new ArrayList<Exception>();
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (IOException e2) {
                    list.add(new Exception(String.format("Failed to close %s", closeable), e2));
                }
            }
            if (!list.isEmpty()) {
                throw new IOExceptionList(list);
            }
        };
    }
}

