/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.reactivex.mantis.network.push.ConsistentHashingRouter;
import io.reactivex.mantis.network.push.HashFunctions;
import io.reactivex.mantis.network.push.KeyValuePair;
import io.reactivex.mantis.network.push.RoundRobinRouter;
import io.reactivex.mantis.network.push.Router;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import rx.functions.Func1;

public class Routers {
    private Routers() {
    }

    public static <K, V> Router<KeyValuePair<K, V>> consistentHashingLegacyTcpProtocol(String name2, Func1<K, byte[]> keyEncoder, final Func1<V, byte[]> valueEncoder) {
        return new ConsistentHashingRouter(name2, new Func1<KeyValuePair<K, V>, byte[]>(){

            @Override
            public byte[] call(KeyValuePair<K, V> kvp) {
                byte[] keyBytes = kvp.getKeyBytes();
                byte[] valueBytes = (byte[])valueEncoder.call(kvp.getValue());
                return ByteBuffer.allocate(10 + keyBytes.length + valueBytes.length).putInt(6 + keyBytes.length + valueBytes.length).put((byte)1).put((byte)1).putInt(keyBytes.length).put(keyBytes).put(valueBytes).array();
            }
        }, HashFunctions.ketama());
    }

    private static byte[] dataPayload(byte[] data2) {
        ByteBuffer buffer = ByteBuffer.allocate(5 + data2.length);
        buffer.putInt(1 + data2.length);
        buffer.put((byte)1);
        buffer.put(data2);
        return buffer.array();
    }

    public static <T> Router<T> roundRobinLegacyTcpProtocol(String name2, final Func1<T, byte[]> toBytes) {
        return new RoundRobinRouter(name2, new Func1<T, byte[]>(){

            @Override
            public byte[] call(T t1) {
                byte[] data2 = (byte[])toBytes.call(t1);
                return Routers.dataPayload(data2);
            }
        });
    }

    public static <T> Router<T> roundRobinSse(String name2, final Func1<T, String> toString) {
        byte[] prefix = "data: ".getBytes();
        byte[] nwnw = "\n\n".getBytes();
        return new RoundRobinRouter(name2, new Func1<T, byte[]>(){

            @Override
            public byte[] call(T data2) {
                byte[] bytes2 = Routers.string().call((String)toString.call(data2));
                return bytes2;
            }
        });
    }

    private static Func1<String, byte[]> stringWithEncoding(String encoding2) {
        final Charset charset = Charset.forName(encoding2);
        return new Func1<String, byte[]>(){

            @Override
            public byte[] call(String value) {
                return value.getBytes(charset);
            }
        };
    }

    public static Func1<String, byte[]> stringAscii() {
        return new Func1<String, byte[]>(){

            @Override
            public byte[] call(String value) {
                byte[] bytes2 = new byte[value.length()];
                for (int i = 0; i < value.length(); ++i) {
                    bytes2[i] = (byte)value.charAt(i);
                }
                return bytes2;
            }
        };
    }

    public static Func1<String, byte[]> stringUtf8() {
        return Routers.stringWithEncoding("UTF-8");
    }

    public static Func1<String, byte[]> string() {
        return Routers.stringUtf8();
    }
}

