/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.channel.local;

import io.mantisrx.shaded.org.jboss.netty.channel.AbstractChannelSink;
import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelException;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelState;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.Channels;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.local.DefaultLocalChannel;
import io.mantisrx.shaded.org.jboss.netty.channel.local.DefaultLocalServerChannel;
import io.mantisrx.shaded.org.jboss.netty.channel.local.LocalAddress;
import io.mantisrx.shaded.org.jboss.netty.channel.local.LocalChannelRegistry;
import java.net.SocketAddress;

final class LocalServerChannelSink
extends AbstractChannelSink {
    LocalServerChannelSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e2) throws Exception {
        Channel channel = e2.getChannel();
        if (channel instanceof DefaultLocalServerChannel) {
            LocalServerChannelSink.handleServerChannel(e2);
        } else if (channel instanceof DefaultLocalChannel) {
            LocalServerChannelSink.handleAcceptedChannel(e2);
        }
    }

    private static void handleServerChannel(ChannelEvent e2) {
        if (!(e2 instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e2;
        DefaultLocalServerChannel channel = (DefaultLocalServerChannel)event.getChannel();
        ChannelFuture future2 = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                LocalServerChannelSink.close(channel, future2);
                break;
            }
            case BOUND: {
                if (value != null) {
                    LocalServerChannelSink.bind(channel, future2, (LocalAddress)value);
                    break;
                }
                LocalServerChannelSink.close(channel, future2);
            }
        }
    }

    private static void handleAcceptedChannel(ChannelEvent e2) {
        if (e2 instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e2;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            ChannelFuture future2 = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.closeNow(future2);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.closeNow(future2);
                    break;
                }
                case INTEREST_OPS: {
                    future2.setSuccess();
                }
            }
        } else if (e2 instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e2;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            boolean offered = channel.writeBuffer.offer(event);
            assert (offered);
            channel.flushWriteBuffer();
        }
    }

    private static void bind(DefaultLocalServerChannel channel, ChannelFuture future2, LocalAddress localAddress) {
        try {
            if (!LocalChannelRegistry.register(localAddress, channel)) {
                throw new ChannelException("address already in use: " + localAddress);
            }
            if (!channel.bound.compareAndSet(false, true)) {
                throw new ChannelException("already bound");
            }
            channel.localAddress = localAddress;
            future2.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)localAddress);
        }
        catch (Throwable t) {
            LocalChannelRegistry.unregister(localAddress);
            future2.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private static void close(DefaultLocalServerChannel channel, ChannelFuture future2) {
        try {
            if (channel.setClosed()) {
                future2.setSuccess();
                LocalAddress localAddress = channel.localAddress;
                if (channel.bound.compareAndSet(true, false)) {
                    channel.localAddress = null;
                    LocalChannelRegistry.unregister(localAddress);
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future2.setSuccess();
            }
        }
        catch (Throwable t) {
            future2.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }
}

