/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.serialize;

import io.mantisrx.shaded.com.fasterxml.jackson.databind.BeanDescription;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.Serializers;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.CollectionLikeType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.ReferenceType;
import io.mantisrx.shaded.io.vavr.jackson.datatype.VavrModule;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.ArraySerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.CharSeqSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.EitherSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.LazySerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.MapSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.MultimapSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.OptionSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.SerializableSerializer;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.TupleSerializer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction2;
import io.vavr.CheckedFunction3;
import io.vavr.CheckedFunction4;
import io.vavr.CheckedFunction5;
import io.vavr.CheckedFunction6;
import io.vavr.CheckedFunction7;
import io.vavr.CheckedFunction8;
import io.vavr.Function0;
import io.vavr.Function1;
import io.vavr.Function2;
import io.vavr.Function3;
import io.vavr.Function4;
import io.vavr.Function5;
import io.vavr.Function6;
import io.vavr.Function7;
import io.vavr.Function8;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.collection.CharSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Multimap;
import io.vavr.collection.PriorityQueue;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Either;
import io.vavr.control.Option;

public class VavrSerializers
extends Serializers.Base {
    private final VavrModule.Settings settings;

    public VavrSerializers(VavrModule.Settings settings) {
        this.settings = settings;
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type2, BeanDescription beanDesc) {
        Class<?> raw = type2.getRawClass();
        if (Either.class.isAssignableFrom(raw)) {
            return new EitherSerializer(type2);
        }
        if (Tuple.class.isAssignableFrom(raw)) {
            return new TupleSerializer(type2);
        }
        if (Function0.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (Function1.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (Function2.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (Function3.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (Function4.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (Function5.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (Function6.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (Function7.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (Function8.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (CheckedFunction0.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (CheckedFunction1.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (CheckedFunction2.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (CheckedFunction3.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (CheckedFunction4.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (CheckedFunction5.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (CheckedFunction6.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (CheckedFunction7.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        if (CheckedFunction8.class.isAssignableFrom(raw)) {
            return new SerializableSerializer(type2);
        }
        return super.findSerializer(config, type2, beanDesc);
    }

    @Override
    public JsonSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType type2, BeanDescription beanDesc, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
        Class<?> raw = type2.getRawClass();
        if (Lazy.class.isAssignableFrom(raw)) {
            return new LazySerializer(type2);
        }
        if (Option.class.isAssignableFrom(raw)) {
            return new OptionSerializer(type2, this.settings.useOptionInPlainFormat());
        }
        return super.findReferenceSerializer(config, type2, beanDesc, contentTypeSerializer, contentValueSerializer);
    }

    @Override
    public JsonSerializer<?> findCollectionLikeSerializer(SerializationConfig config, CollectionLikeType type2, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        Class<?> raw = type2.getRawClass();
        if (raw == CharSeq.class) {
            return new CharSeqSerializer(type2);
        }
        if (Seq.class.isAssignableFrom(raw)) {
            return new ArraySerializer(type2);
        }
        if (Set.class.isAssignableFrom(raw)) {
            return new ArraySerializer(type2);
        }
        if (PriorityQueue.class.isAssignableFrom(raw)) {
            return new ArraySerializer(type2);
        }
        return super.findCollectionLikeSerializer(config, type2, beanDesc, elementTypeSerializer, elementValueSerializer);
    }

    @Override
    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type2, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        Class<?> raw = type2.getRawClass();
        if (Map.class.isAssignableFrom(raw)) {
            return new MapSerializer(type2);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new MultimapSerializer(type2);
        }
        return super.findMapLikeSerializer(config, type2, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
    }
}

