/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.committer.watermarks;

import io.mantisrx.connector.iceberg.sink.committer.watermarks.PropertyAwareWatermarkExtractor;
import javax.annotation.Nullable;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;

public interface WatermarkExtractor {
    @Nullable
    public Long getWatermark(Table var1);

    @Nullable
    default public Long getWatermark(Transaction transaction) {
        return this.getWatermark(transaction.table());
    }

    public void setWatermark(Transaction var1, Long var2);

    default public void setWatermark(Table table, Long watermark) {
        this.setWatermark(table.newTransaction(), watermark);
    }

    public static WatermarkExtractor noop() {
        return new WatermarkExtractor(){

            @Override
            @Nullable
            public Long getWatermark(Table table) {
                return null;
            }

            @Override
            public void setWatermark(Transaction transaction, Long watermark) {
            }
        };
    }

    public static WatermarkExtractor propertiesAware(String propertyKey) {
        return new PropertyAwareWatermarkExtractor(propertyKey);
    }
}

