/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.committer.watermarks;

import io.mantisrx.connector.iceberg.sink.committer.watermarks.WatermarkExtractor;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyAwareWatermarkExtractor
implements WatermarkExtractor {
    private static final Logger log = LoggerFactory.getLogger(PropertyAwareWatermarkExtractor.class);
    private final String propertyKey;

    @Override
    @Nullable
    public Long getWatermark(Table table) {
        try {
            return Long.parseLong((String)table.properties().get(this.propertyKey));
        }
        catch (Exception e) {
            log.error("Failed to extract watermark from the table", (Throwable)e);
            return null;
        }
    }

    @Override
    public void setWatermark(Transaction transaction, Long watermark) {
        UpdateProperties updateProperties = transaction.updateProperties();
        updateProperties.set(this.propertyKey, Long.toString(watermark));
        updateProperties.commit();
        log.info("Iceberg committer for table={} set VTTS watermark to {}", (Object)transaction.table(), (Object)watermark);
    }

    @ConstructorProperties(value={"propertyKey"})
    PropertyAwareWatermarkExtractor(String propertyKey) {
        this.propertyKey = propertyKey;
    }
}

