/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.primitives;

import io.mantisrx.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.com.google.common.annotations.GwtCompatible;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import io.mantisrx.shaded.com.google.common.primitives.Longs;
import io.mantisrx.shaded.com.google.common.primitives.ParseRequest;
import io.mantisrx.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
public final class UnsignedLongs {
    public static final long MAX_VALUE = -1L;

    private UnsignedLongs() {
    }

    private static long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    public static int compare(long a, long b) {
        return Longs.compare(UnsignedLongs.flip(a), UnsignedLongs.flip(b));
    }

    public static long min(long ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        long min2 = UnsignedLongs.flip(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            long next2 = UnsignedLongs.flip(array2[i]);
            if (next2 >= min2) continue;
            min2 = next2;
        }
        return UnsignedLongs.flip(min2);
    }

    public static long max(long ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        long max2 = UnsignedLongs.flip(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            long next2 = UnsignedLongs.flip(array2[i]);
            if (next2 <= max2) continue;
            max2 = next2;
        }
        return UnsignedLongs.flip(max2);
    }

    public static String join(String separator, long ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(UnsignedLongs.toString(array2[0]));
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(UnsignedLongs.toString(array2[i]));
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(long[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedLongs.sort(array2, 0, array2.length);
    }

    public static void sort(long[] array2, int fromIndex, int toIndex) {
        int i;
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        for (i = fromIndex; i < toIndex; ++i) {
            array2[i] = UnsignedLongs.flip(array2[i]);
        }
        Arrays.sort(array2, fromIndex, toIndex);
        for (i = fromIndex; i < toIndex; ++i) {
            array2[i] = UnsignedLongs.flip(array2[i]);
        }
    }

    public static void sortDescending(long[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedLongs.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(long[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array2[n] = array2[n] ^ Long.MAX_VALUE;
        }
        Arrays.sort(array2, fromIndex, toIndex);
        i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array2[n] = array2[n] ^ Long.MAX_VALUE;
        }
    }

    public static long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem2 = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(UnsignedLongs.compare(rem2, divisor) >= 0 ? 1 : 0);
    }

    public static long remainder(long dividend, long divisor) {
        long rem2;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem2 - (UnsignedLongs.compare(rem2 = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }

    @CanIgnoreReturnValue
    public static long parseUnsignedLong(String string2) {
        return UnsignedLongs.parseUnsignedLong(string2, 10);
    }

    @CanIgnoreReturnValue
    public static long parseUnsignedLong(String string2, int radix) {
        Preconditions.checkNotNull(string2);
        if (string2.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException(new StringBuilder(26).append("illegal radix: ").append(radix).toString());
        }
        int maxSafePos = ParseOverflowDetection.maxSafeDigits[radix] - 1;
        long value = 0L;
        for (int pos = 0; pos < string2.length(); ++pos) {
            int digit = Character.digit(string2.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(string2);
            }
            if (pos > maxSafePos && ParseOverflowDetection.overflowInParse(value, digit, radix)) {
                String string3 = String.valueOf(string2);
                throw new NumberFormatException(string3.length() != 0 ? "Too large for unsigned long: ".concat(string3) : new String("Too large for unsigned long: "));
            }
            value = value * (long)radix + (long)digit;
        }
        return value;
    }

    @CanIgnoreReturnValue
    public static long decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedLongs.parseUnsignedLong(request.rawValue, request.radix);
        }
        catch (NumberFormatException e2) {
            String string2 = String.valueOf(stringValue);
            NumberFormatException decodeException = new NumberFormatException(string2.length() != 0 ? "Error parsing value: ".concat(string2) : new String("Error parsing value: "));
            decodeException.initCause(e2);
            throw decodeException;
        }
    }

    public static String toString(long x) {
        return UnsignedLongs.toString(x, 10);
    }

    public static String toString(long x, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        if (x == 0L) {
            return "0";
        }
        if (x > 0L) {
            return Long.toString(x, radix);
        }
        char[] buf = new char[64];
        int i = buf.length;
        if ((radix & radix - 1) == 0) {
            int shift = Integer.numberOfTrailingZeros(radix);
            int mask = radix - 1;
            do {
                buf[--i] = Character.forDigit((int)x & mask, radix);
            } while ((x >>>= shift) != 0L);
        } else {
            long quotient = (radix & 1) == 0 ? (x >>> 1) / (long)(radix >>> 1) : UnsignedLongs.divide(x, radix);
            long rem2 = x - quotient * (long)radix;
            buf[--i] = Character.forDigit((int)rem2, radix);
            for (x = quotient; x > 0L; x /= (long)radix) {
                buf[--i] = Character.forDigit((int)(x % (long)radix), radix);
            }
        }
        return new String(buf, i, buf.length - i);
    }

    private static final class ParseOverflowDetection {
        static final long[] maxValueDivs = new long[37];
        static final int[] maxValueMods = new int[37];
        static final int[] maxSafeDigits = new int[37];

        private ParseOverflowDetection() {
        }

        static boolean overflowInParse(long current, int digit, int radix) {
            if (current >= 0L) {
                if (current < maxValueDivs[radix]) {
                    return false;
                }
                if (current > maxValueDivs[radix]) {
                    return true;
                }
                return digit > maxValueMods[radix];
            }
            return true;
        }

        static {
            BigInteger overflow = new BigInteger("10000000000000000", 16);
            for (int i = 2; i <= 36; ++i) {
                ParseOverflowDetection.maxValueDivs[i] = UnsignedLongs.divide(-1L, i);
                ParseOverflowDetection.maxValueMods[i] = (int)UnsignedLongs.remainder(-1L, i);
                ParseOverflowDetection.maxSafeDigits[i] = overflow.toString(i).length() - 1;
            }
        }
    }

    static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left2, long[] right2) {
            int minLength = Math.min(left2.length, right2.length);
            for (int i = 0; i < minLength; ++i) {
                if (left2[i] == right2[i]) continue;
                return UnsignedLongs.compare(left2[i], right2[i]);
            }
            return left2.length - right2.length;
        }

        public String toString() {
            return "UnsignedLongs.lexicographicalComparator()";
        }
    }
}

