/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.eventbus;

import io.mantisrx.shaded.com.google.common.base.MoreObjects;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.eventbus.DeadEvent;
import io.mantisrx.shaded.com.google.common.eventbus.Dispatcher;
import io.mantisrx.shaded.com.google.common.eventbus.ElementTypesAreNonnullByDefault;
import io.mantisrx.shaded.com.google.common.eventbus.Subscriber;
import io.mantisrx.shaded.com.google.common.eventbus.SubscriberExceptionContext;
import io.mantisrx.shaded.com.google.common.eventbus.SubscriberExceptionHandler;
import io.mantisrx.shaded.com.google.common.eventbus.SubscriberRegistry;
import io.mantisrx.shaded.com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
public class EventBus {
    private static final Logger logger = Logger.getLogger(EventBus.class.getName());
    private final String identifier;
    private final Executor executor;
    private final SubscriberExceptionHandler exceptionHandler;
    private final SubscriberRegistry subscribers = new SubscriberRegistry(this);
    private final Dispatcher dispatcher;

    public EventBus() {
        this("default");
    }

    public EventBus(String identifier) {
        this(identifier, MoreExecutors.directExecutor(), Dispatcher.perThreadDispatchQueue(), LoggingHandler.INSTANCE);
    }

    public EventBus(SubscriberExceptionHandler exceptionHandler) {
        this("default", MoreExecutors.directExecutor(), Dispatcher.perThreadDispatchQueue(), exceptionHandler);
    }

    EventBus(String identifier, Executor executor, Dispatcher dispatcher, SubscriberExceptionHandler exceptionHandler) {
        this.identifier = Preconditions.checkNotNull(identifier);
        this.executor = Preconditions.checkNotNull(executor);
        this.dispatcher = Preconditions.checkNotNull(dispatcher);
        this.exceptionHandler = Preconditions.checkNotNull(exceptionHandler);
    }

    public final String identifier() {
        return this.identifier;
    }

    final Executor executor() {
        return this.executor;
    }

    void handleSubscriberException(Throwable e2, SubscriberExceptionContext context) {
        Preconditions.checkNotNull(e2);
        Preconditions.checkNotNull(context);
        try {
            this.exceptionHandler.handleException(e2, context);
        }
        catch (Throwable e22) {
            logger.log(Level.SEVERE, String.format(Locale.ROOT, "Exception %s thrown while handling exception: %s", e22, e2), e22);
        }
    }

    public void register(Object object) {
        this.subscribers.register(object);
    }

    public void unregister(Object object) {
        this.subscribers.unregister(object);
    }

    public void post(Object event) {
        Iterator<Subscriber> eventSubscribers = this.subscribers.getSubscribers(event);
        if (eventSubscribers.hasNext()) {
            this.dispatcher.dispatch(event, eventSubscribers);
        } else if (!(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.identifier).toString();
    }

    static final class LoggingHandler
    implements SubscriberExceptionHandler {
        static final LoggingHandler INSTANCE = new LoggingHandler();

        LoggingHandler() {
        }

        @Override
        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            Logger logger = LoggingHandler.logger(context);
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, LoggingHandler.message(context), exception);
            }
        }

        private static Logger logger(SubscriberExceptionContext context) {
            String string2 = EventBus.class.getName();
            String string3 = context.getEventBus().identifier();
            return Logger.getLogger(new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(".").append(string3).toString());
        }

        private static String message(SubscriberExceptionContext context) {
            Method method = context.getSubscriberMethod();
            String string2 = method.getName();
            String string3 = method.getParameterTypes()[0].getName();
            String string4 = String.valueOf(context.getSubscriber());
            String string5 = String.valueOf(context.getEvent());
            return new StringBuilder(80 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Exception thrown by subscriber method ").append(string2).append('(').append(string3).append(')').append(" on subscriber ").append(string4).append(" when dispatching event: ").append(string5).toString();
        }
    }
}

