/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.spectator.GaugeCallback;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredThreadPool {
    private static final Logger logger = LoggerFactory.getLogger(MonitoredThreadPool.class);
    private String name;
    private ThreadPoolExecutor threadPool;
    private Metrics metrics;
    private Counter rejectCount;
    private Counter exceptions;

    public MonitoredThreadPool(String name2, ThreadPoolExecutor threadPool) {
        this.name = name2;
        this.threadPool = threadPool;
        this.threadPool.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable arg0, ThreadPoolExecutor arg1) {
                MonitoredThreadPool.this.rejected();
            }
        });
        String poolId = Optional.ofNullable(name2).orElse("none");
        BasicTag tag = new BasicTag("groupId", poolId);
        MetricGroupId metricsGroup = new MetricGroupId("MonitoredThreadPool", new Tag[]{tag});
        GaugeCallback activeTasks = new GaugeCallback(metricsGroup, "activeTasks", () -> threadPool.getActiveCount());
        GaugeCallback queueLength = new GaugeCallback(metricsGroup, "queueLength", () -> threadPool.getQueue().size());
        this.metrics = new Metrics.Builder().id(metricsGroup).addCounter("rejectCount").addCounter("exceptions").addGauge(activeTasks).addGauge(queueLength).build();
        this.rejectCount = this.metrics.getCounter("rejectCount");
        this.exceptions = this.metrics.getCounter("exceptions");
    }

    private void rejected() {
        logger.warn("Monitored thread pool: " + this.name + " rejected task.");
        this.rejectCount.increment();
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public int getMaxPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    public <T> Future<T> submit(final Callable<T> task) {
        Future future2 = this.threadPool.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object returnValue = null;
                try {
                    returnValue = task.call();
                }
                catch (Exception e2) {
                    logger.warn("Exception occured in running thread", e2);
                    MonitoredThreadPool.this.exceptions.increment();
                }
                return returnValue;
            }
        });
        return future2;
    }

    public void execute(final Runnable task) {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Exception e2) {
                    logger.warn("Exception occured in running thread", e2);
                    MonitoredThreadPool.this.exceptions.increment();
                }
            }
        });
    }
}

