/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonParser;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonToken;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.mantisrx.shaded.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class OffsetTimeDeserializer
extends JSR310DateTimeDeserializerBase<OffsetTime> {
    private static final long serialVersionUID = 1L;
    public static final OffsetTimeDeserializer INSTANCE = new OffsetTimeDeserializer();

    protected OffsetTimeDeserializer() {
        this(DateTimeFormatter.ISO_OFFSET_TIME);
    }

    protected OffsetTimeDeserializer(DateTimeFormatter dtf) {
        super(OffsetTime.class, dtf);
    }

    protected OffsetTimeDeserializer(OffsetTimeDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    protected OffsetTimeDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new OffsetTimeDeserializer(dtf);
    }

    @Override
    protected OffsetTimeDeserializer withLeniency(Boolean leniency) {
        return new OffsetTimeDeserializer(this, leniency);
    }

    protected OffsetTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public OffsetTime deserialize(JsonParser parser2, DeserializationContext context) throws IOException {
        if (parser2.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(parser2, context, parser2.getText());
        }
        if (parser2.isExpectedStartObjectToken()) {
            return this._fromString(parser2, context, context.extractScalarFromObject(parser2, this, this.handledType()));
        }
        if (!parser2.isExpectedStartArrayToken()) {
            if (parser2.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
                return (OffsetTime)parser2.getEmbeddedObject();
            }
            if (parser2.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                this._throwNoNumericTimestampNeedTimeZone(parser2, context);
            }
            throw context.wrongTokenException(parser2, this.handledType(), JsonToken.START_ARRAY, "Expected array or string.");
        }
        JsonToken t = parser2.nextToken();
        if (t != JsonToken.VALUE_NUMBER_INT) {
            if (t == JsonToken.END_ARRAY) {
                return null;
            }
            if ((t == JsonToken.VALUE_STRING || t == JsonToken.VALUE_EMBEDDED_OBJECT) && context.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                OffsetTime parsed = this.deserialize(parser2, context);
                if (parser2.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(parser2, context);
                }
                return parsed;
            }
            context.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{t});
        }
        int hour = parser2.getIntValue();
        int minute = parser2.nextIntValue(-1);
        if (minute == -1) {
            t = parser2.getCurrentToken();
            if (t == JsonToken.END_ARRAY) {
                return null;
            }
            if (t != JsonToken.VALUE_NUMBER_INT) {
                this._reportWrongToken(context, JsonToken.VALUE_NUMBER_INT, "minutes");
            }
            minute = parser2.getIntValue();
        }
        int partialSecond = 0;
        int second = 0;
        if (parser2.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            second = parser2.getIntValue();
            if (parser2.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                partialSecond = parser2.getIntValue();
                if (partialSecond < 1000 && !context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                    partialSecond *= 1000000;
                }
                parser2.nextToken();
            }
        }
        if (parser2.getCurrentToken() == JsonToken.VALUE_STRING) {
            OffsetTime result = OffsetTime.of(hour, minute, second, partialSecond, ZoneOffset.of(parser2.getText()));
            if (parser2.nextToken() != JsonToken.END_ARRAY) {
                this._reportWrongToken(context, JsonToken.END_ARRAY, "timezone");
            }
            return result;
        }
        throw context.wrongTokenException(parser2, this.handledType(), JsonToken.VALUE_STRING, "Expected string for TimeZone after numeric values");
    }

    protected OffsetTime _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string2 = string0.trim();
        if (string2.length() == 0) {
            return (OffsetTime)this._fromEmptyString(p, ctxt, string2);
        }
        try {
            return OffsetTime.parse(string2, this._formatter);
        }
        catch (DateTimeException e2) {
            return (OffsetTime)this._handleDateTimeException(ctxt, e2, string2);
        }
    }
}

