/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.core.functions;

import io.mantisrx.common.MantisGroup;
import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.computation.Computation;
import io.mantisrx.runtime.computation.GroupToScalarComputation;
import io.mantisrx.runtime.computation.ScalarComputation;
import io.mantisrx.runtime.core.WindowSpec;
import io.mantisrx.runtime.core.functions.FilterFunction;
import io.mantisrx.runtime.core.functions.FlatMapFunction;
import io.mantisrx.runtime.core.functions.MantisFunction;
import io.mantisrx.runtime.core.functions.MapFunction;
import io.mantisrx.runtime.core.functions.ReduceFunction;
import io.mantisrx.runtime.core.functions.ReduceFunctionImpl;
import io.mantisrx.runtime.core.functions.WindowFunction;
import io.mantisrx.shaded.com.google.common.annotations.VisibleForTesting;
import io.mantisrx.shaded.com.google.common.collect.ImmutableCollection;
import io.mantisrx.shaded.com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;

public class FunctionCombinator<T, R> {
    private final boolean isKeyed;
    private final List<MantisFunction> functions;

    public FunctionCombinator(boolean isKeyed) {
        this(isKeyed, ImmutableList.of());
    }

    public FunctionCombinator(boolean isKeyed, List<MantisFunction> functions) {
        this.isKeyed = isKeyed;
        this.functions = functions;
    }

    public <IN, OUT> FunctionCombinator<T, OUT> add(MantisFunction fn2) {
        ImmutableCollection functions = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.functions)).add(fn2)).build();
        return new FunctionCombinator<T, R>(this.isKeyed, (List<MantisFunction>)((Object)functions));
    }

    public int size() {
        return this.functions.size();
    }

    @VisibleForTesting
    <U, V> ScalarComputation<U, V> makeScalarStage() {
        return new ScalarComputation<U, V>(){

            @Override
            public void init(Context context) {
                FunctionCombinator.this.functions.forEach(MantisFunction::init);
            }

            @Override
            public Observable<V> call(Context context, Observable<U> uObservable) {
                Observable<Object> current = uObservable;
                for (MantisFunction fn2 : FunctionCombinator.this.functions) {
                    if (fn2 instanceof FilterFunction) {
                        current = current.filter(((FilterFunction)fn2)::apply);
                        continue;
                    }
                    if (fn2 instanceof MapFunction) {
                        current = current.map(e2 -> ((MapFunction)fn2).apply(e2));
                        continue;
                    }
                    if (!(fn2 instanceof FlatMapFunction)) continue;
                    current = current.flatMap(e2 -> Observable.from(((FlatMapFunction)fn2).apply(e2)));
                }
                return current;
            }
        };
    }

    @VisibleForTesting
    <K, U, V> GroupToScalarComputation<K, U, V> makeGroupToScalarStage() {
        return new GroupToScalarComputation<K, U, V>(){

            @Override
            public void init(Context context) {
                FunctionCombinator.this.functions.forEach(MantisFunction::init);
            }

            @Override
            public Observable<V> call(Context context, Observable<MantisGroup<K, U>> gobs) {
                Observable observable = gobs.groupBy(MantisGroup::getKeyValue).flatMap(gob -> {
                    Observable<Object> current = gob.map(MantisGroup::getValue);
                    Object key2 = gob.getKey();
                    for (MantisFunction fn2 : FunctionCombinator.this.functions) {
                        if (fn2 instanceof FilterFunction) {
                            current = current.filter(((FilterFunction)fn2)::apply);
                            continue;
                        }
                        if (fn2 instanceof MapFunction) {
                            current = current.map(x -> ((MapFunction)fn2).apply(x));
                            continue;
                        }
                        if (fn2 instanceof FlatMapFunction) {
                            current = current.flatMap(x -> Observable.from(((FlatMapFunction)fn2).apply(x)));
                            continue;
                        }
                        if (fn2 instanceof WindowFunction) {
                            current = FunctionCombinator.this.handleWindows(current, (WindowFunction)fn2);
                            continue;
                        }
                        if (!(fn2 instanceof ReduceFunction)) continue;
                        ReduceFunction reduceFn = (ReduceFunction)fn2;
                        current = current.map(obs -> obs.reduce(reduceFn.initialValue(), (acc, e2) -> reduceFn.reduce(acc, e2))).flatMap(x -> x).filter(x -> x != ReduceFunctionImpl.EMPTY);
                    }
                    return current;
                });
                return observable;
            }
        };
    }

    private Observable<? extends Observable<?>> handleWindows(Observable<?> obs, WindowFunction<?> windowFn) {
        WindowSpec spec = windowFn.getSpec();
        switch (spec.getType()) {
            case ELEMENT: 
            case ELEMENT_SLIDING: {
                return obs.window(spec.getNumElements(), spec.getElementOffset());
            }
            case TUMBLING: 
            case SLIDING: {
                return obs.window(spec.getWindowLength().toMillis(), spec.getWindowOffset().toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        throw new UnsupportedOperationException("Unknown WindowSpec must be one of " + Arrays.toString((Object[])WindowSpec.WindowType.values()));
    }

    public Computation makeStage() {
        if (this.size() == 0) {
            return null;
        }
        if (this.isKeyed) {
            return this.makeGroupToScalarStage();
        }
        return this.makeScalarStage();
    }

    public boolean isKeyed() {
        return this.isKeyed;
    }
}

