/*
 * Decompiled with CFR 0.152.
 */
package rx.math.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class OperatorAverageLong<T>
implements Observable.Operator<Long, T> {
    final Func1<? super T, Long> valueExtractor;

    public OperatorAverageLong(Func1<? super T, Long> valueExtractor) {
        this.valueExtractor = valueExtractor;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Long> child) {
        return new AverageObserver(child);
    }

    private final class AverageObserver
    extends Subscriber<T> {
        final Subscriber<? super Long> child;
        long sum;
        int count;

        public AverageObserver(Subscriber<? super Long> subscriber2) {
            super(subscriber2);
            this.child = subscriber2;
        }

        @Override
        public void onNext(T args) {
            this.sum += OperatorAverageLong.this.valueExtractor.call(args).longValue();
            ++this.count;
        }

        @Override
        public void onError(Throwable e2) {
            this.child.onError(e2);
        }

        @Override
        public void onCompleted() {
            if (this.count > 0) {
                try {
                    this.child.onNext((Long)(this.sum / (long)this.count));
                }
                catch (Throwable t) {
                    this.child.onError(t);
                    return;
                }
                this.child.onCompleted();
            } else {
                this.child.onError(new IllegalArgumentException("Sequence contains no elements"));
            }
        }
    }
}

