/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;

public final class OperatorSubscribeOn<T>
implements Observable.OnSubscribe<T> {
    final Scheduler scheduler;
    final Observable<T> source;
    final boolean requestOn;

    public OperatorSubscribeOn(Observable<T> source2, Scheduler scheduler, boolean requestOn) {
        this.scheduler = scheduler;
        this.source = source2;
        this.requestOn = requestOn;
    }

    @Override
    public void call(Subscriber<? super T> subscriber2) {
        Scheduler.Worker inner = this.scheduler.createWorker();
        SubscribeOnSubscriber<? super T> parent = new SubscribeOnSubscriber<T>(subscriber2, this.requestOn, inner, this.source);
        subscriber2.add(parent);
        subscriber2.add(inner);
        inner.schedule(parent);
    }

    static final class SubscribeOnSubscriber<T>
    extends Subscriber<T>
    implements Action0 {
        final Subscriber<? super T> actual;
        final boolean requestOn;
        final Scheduler.Worker worker;
        Observable<T> source;
        Thread t;

        SubscribeOnSubscriber(Subscriber<? super T> actual, boolean requestOn, Scheduler.Worker worker, Observable<T> source2) {
            this.actual = actual;
            this.requestOn = requestOn;
            this.worker = worker;
            this.source = source2;
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable e2) {
            try {
                this.actual.onError(e2);
            }
            finally {
                this.worker.unsubscribe();
            }
        }

        @Override
        public void onCompleted() {
            try {
                this.actual.onCompleted();
            }
            finally {
                this.worker.unsubscribe();
            }
        }

        @Override
        public void call() {
            Observable<T> src = this.source;
            this.source = null;
            this.t = Thread.currentThread();
            src.unsafeSubscribe(this);
        }

        @Override
        public void setProducer(final Producer p) {
            this.actual.setProducer(new Producer(){

                @Override
                public void request(final long n) {
                    if (SubscribeOnSubscriber.this.t == Thread.currentThread() || !SubscribeOnSubscriber.this.requestOn) {
                        p.request(n);
                    } else {
                        SubscribeOnSubscriber.this.worker.schedule(new Action0(){

                            @Override
                            public void call() {
                                p.request(n);
                            }
                        });
                    }
                }
            });
        }
    }
}

