/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.pipeline;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.ReadTimeoutException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalReadTimeoutHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(InternalReadTimeoutHandler.class);
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long timeoutNanos;
    private volatile ScheduledFuture<?> timeout;
    private volatile long lastReadTime;
    private volatile State state = State.Created;
    private boolean closed;

    public InternalReadTimeoutHandler(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timeoutNanos = timeout <= 0L ? 0L : Math.max(unit.toNanos(timeout), MIN_TIMEOUT_NANOS);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.scheduleAfresh(ctx);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            this.scheduleAfresh(ctx);
        }
        super.channelRegistered(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.scheduleAfresh(ctx);
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.lastReadTime = System.nanoTime();
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(final ChannelHandlerContext ctx, Object msg, ChannelPromise promise2) throws Exception {
        if (State.Paused == this.state) {
            promise2.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future2) throws Exception {
                    if (State.Paused == InternalReadTimeoutHandler.this.state) {
                        InternalReadTimeoutHandler.this.scheduleAfresh(ctx);
                    }
                }
            });
        }
        super.write(ctx, msg, promise2);
    }

    void cancelTimeoutSchedule(ChannelHandlerContext ctx) {
        assert (ctx.channel().eventLoop().inEventLoop());
        if (State.Active == this.state) {
            this.state = State.Paused;
            this.timeout.cancel(false);
        }
    }

    private void scheduleAfresh(ChannelHandlerContext ctx) {
        switch (this.state) {
            case Created: {
                break;
            }
            case Active: {
                logger.warn("Not scheduling next read timeout task as it is already active.");
                return;
            }
            case Paused: {
                break;
            }
            case Destroyed: {
                logger.warn("Not scheduling next read timeout task as the channel handler is removed.");
                return;
            }
        }
        this.state = State.Active;
        this.lastReadTime = System.nanoTime();
        if (this.timeoutNanos > 0L) {
            this.timeout = ctx.executor().schedule(new ReadTimeoutTask(ctx), this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
    }

    private void destroy() {
        this.state = State.Destroyed;
        if (this.timeout != null) {
            this.timeout.cancel(false);
            this.timeout = null;
        }
    }

    protected void readTimedOut(ChannelHandlerContext ctx) throws Exception {
        if (!this.closed) {
            ctx.fireExceptionCaught(ReadTimeoutException.INSTANCE);
            ctx.close();
            this.closed = true;
        }
    }

    private final class ReadTimeoutTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        ReadTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            long currentTime = System.nanoTime();
            long nextDelay = InternalReadTimeoutHandler.this.timeoutNanos - (currentTime - InternalReadTimeoutHandler.this.lastReadTime);
            if (nextDelay <= 0L) {
                InternalReadTimeoutHandler.this.timeout = this.ctx.executor().schedule(this, InternalReadTimeoutHandler.this.timeoutNanos, TimeUnit.NANOSECONDS);
                try {
                    InternalReadTimeoutHandler.this.readTimedOut(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireExceptionCaught(t);
                }
            } else {
                InternalReadTimeoutHandler.this.timeout = this.ctx.executor().schedule(this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    private static enum State {
        Created,
        Active,
        Paused,
        Destroyed;

    }
}

