/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.persistence;

import io.mantisrx.shaded.org.apache.jute.BinaryInputArchive;
import io.mantisrx.shaded.org.apache.jute.BinaryOutputArchive;
import io.mantisrx.shaded.org.apache.jute.Record;
import io.mantisrx.shaded.org.apache.zookeeper.server.TraceFormatter;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.FileHeader;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.FilePadding;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.FileTxnLog;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.TxnLogToolkitCliParser;
import io.mantisrx.shaded.org.apache.zookeeper.server.util.SerializeUtils;
import io.mantisrx.shaded.org.apache.zookeeper.txn.TxnHeader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Scanner;
import java.util.zip.Adler32;

public class TxnLogToolkit
implements Closeable {
    private File txnLogFile;
    private boolean recoveryMode = false;
    private boolean verbose = false;
    private FileInputStream txnFis;
    private BinaryInputArchive logStream;
    private int crcFixed = 0;
    private FileOutputStream recoveryFos;
    private BinaryOutputArchive recoveryOa;
    private File recoveryLogFile;
    private FilePadding filePadding = new FilePadding();
    private boolean force = false;

    public static void main(String[] args) throws Exception {
        TxnLogToolkit lt = TxnLogToolkit.parseCommandLine(args);
        try {
            lt.dump(new Scanner(System.in));
            lt.printStat();
        }
        catch (TxnLogToolkitParseException e2) {
            System.err.println(e2.getMessage() + "\n");
            TxnLogToolkitCliParser.printHelpAndExit(e2.getExitCode());
        }
        catch (TxnLogToolkitException e3) {
            System.err.println(e3.getMessage());
            System.exit(e3.getExitCode());
        }
        finally {
            lt.close();
        }
    }

    public TxnLogToolkit(boolean recoveryMode, boolean verbose, String txnLogFileName, boolean force2) throws FileNotFoundException, TxnLogToolkitException {
        this.recoveryMode = recoveryMode;
        this.verbose = verbose;
        this.force = force2;
        this.txnLogFile = new File(txnLogFileName);
        if (!this.txnLogFile.exists() || !this.txnLogFile.canRead()) {
            throw new TxnLogToolkitException(1, "File doesn't exist or not readable: %s", this.txnLogFile);
        }
        if (recoveryMode) {
            this.recoveryLogFile = new File(this.txnLogFile.toString() + ".fixed");
            if (this.recoveryLogFile.exists()) {
                throw new TxnLogToolkitException(1, "Recovery file %s already exists or not writable", this.recoveryLogFile);
            }
        }
        this.openTxnLogFile();
        if (recoveryMode) {
            this.openRecoveryFile();
        }
    }

    public void dump(Scanner scanner) throws Exception {
        this.crcFixed = 0;
        FileHeader fhdr = new FileHeader();
        fhdr.deserialize(this.logStream, "fileheader");
        if (fhdr.getMagic() != FileTxnLog.TXNLOG_MAGIC) {
            throw new TxnLogToolkitException(2, "Invalid magic number for %s", this.txnLogFile.getName());
        }
        System.out.println("ZooKeeper Transactional Log File with dbid " + fhdr.getDbid() + " txnlog format version " + fhdr.getVersion());
        if (this.recoveryMode) {
            fhdr.serialize(this.recoveryOa, "fileheader");
            this.recoveryFos.flush();
            this.filePadding.setCurrentSize(this.recoveryFos.getChannel().position());
        }
        int count2 = 0;
        while (true) {
            byte[] bytes2;
            long crcValue;
            try {
                crcValue = this.logStream.readLong("crcvalue");
                bytes2 = this.logStream.readBuffer("txnEntry");
            }
            catch (EOFException e2) {
                System.out.println("EOF reached after " + count2 + " txns.");
                return;
            }
            if (bytes2.length == 0) {
                System.out.println("EOF reached after " + count2 + " txns.");
                return;
            }
            Adler32 crc = new Adler32();
            crc.update(bytes2, 0, bytes2.length);
            if (crcValue != crc.getValue()) {
                if (this.recoveryMode) {
                    if (!this.force) {
                        this.printTxn(bytes2, "CRC ERROR");
                        if (this.askForFix(scanner)) {
                            crcValue = crc.getValue();
                            ++this.crcFixed;
                        }
                    } else {
                        crcValue = crc.getValue();
                        this.printTxn(bytes2, "CRC FIXED");
                        ++this.crcFixed;
                    }
                } else {
                    this.printTxn(bytes2, "CRC ERROR");
                }
            }
            if (!this.recoveryMode || this.verbose) {
                this.printTxn(bytes2);
            }
            if (this.logStream.readByte("EOR") != 66) {
                throw new TxnLogToolkitException(1, "Last transaction was partial.", new Object[0]);
            }
            if (this.recoveryMode) {
                this.filePadding.padFile(this.recoveryFos.getChannel());
                this.recoveryOa.writeLong(crcValue, "crcvalue");
                this.recoveryOa.writeBuffer(bytes2, "txnEntry");
                this.recoveryOa.writeByte((byte)66, "EOR");
            }
            ++count2;
        }
    }

    private boolean askForFix(Scanner scanner) throws TxnLogToolkitException {
        while (true) {
            System.out.print("Would you like to fix it (Yes/No/Abort) ? ");
            char answer = Character.toUpperCase(scanner.next().charAt(0));
            switch (answer) {
                case 'Y': {
                    return true;
                }
                case 'N': {
                    return false;
                }
                case 'A': {
                    throw new TxnLogToolkitException(0, "Recovery aborted.", new Object[0]);
                }
            }
        }
    }

    private void printTxn(byte[] bytes2) throws IOException {
        this.printTxn(bytes2, "");
    }

    private void printTxn(byte[] bytes2, String prefix) throws IOException {
        TxnHeader hdr = new TxnHeader();
        Record txn = SerializeUtils.deserializeTxn(bytes2, hdr);
        String txns = String.format("%s session 0x%s cxid 0x%s zxid 0x%s %s %s", DateFormat.getDateTimeInstance(3, 1).format(new Date(hdr.getTime())), Long.toHexString(hdr.getClientId()), Long.toHexString(hdr.getCxid()), Long.toHexString(hdr.getZxid()), TraceFormatter.op2String(hdr.getType()), txn);
        if (prefix != null && !"".equals(prefix.trim())) {
            System.out.print(prefix + " - ");
        }
        if (txns.endsWith("\n")) {
            System.out.print(txns);
        } else {
            System.out.println(txns);
        }
    }

    private void openTxnLogFile() throws FileNotFoundException {
        this.txnFis = new FileInputStream(this.txnLogFile);
        this.logStream = BinaryInputArchive.getArchive(this.txnFis);
    }

    private void closeTxnLogFile() throws IOException {
        if (this.txnFis != null) {
            this.txnFis.close();
        }
    }

    private void openRecoveryFile() throws FileNotFoundException {
        this.recoveryFos = new FileOutputStream(this.recoveryLogFile);
        this.recoveryOa = BinaryOutputArchive.getArchive(this.recoveryFos);
    }

    private void closeRecoveryFile() throws IOException {
        if (this.recoveryFos != null) {
            this.recoveryFos.close();
        }
    }

    private static TxnLogToolkit parseCommandLine(String[] args) throws TxnLogToolkitException, FileNotFoundException {
        TxnLogToolkitCliParser parser2 = new TxnLogToolkitCliParser();
        parser2.parse(args);
        return new TxnLogToolkit(parser2.isRecoveryMode(), parser2.isVerbose(), parser2.getTxnLogFileName(), parser2.isForce());
    }

    private void printStat() {
        if (this.recoveryMode) {
            System.out.printf("Recovery file %s has been written with %d fixed CRC error(s)%n", this.recoveryLogFile, this.crcFixed);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.recoveryMode) {
            this.closeRecoveryFile();
        }
        this.closeTxnLogFile();
    }

    static class TxnLogToolkitParseException
    extends TxnLogToolkitException {
        private static final long serialVersionUID = 1L;

        TxnLogToolkitParseException(int exitCode, String message, Object ... params) {
            super(exitCode, message, params);
        }
    }

    static class TxnLogToolkitException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int exitCode;

        TxnLogToolkitException(int exitCode, String message, Object ... params) {
            super(String.format(message, params));
            this.exitCode = exitCode;
        }

        int getExitCode() {
            return this.exitCode;
        }
    }
}

