/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.committer;

import io.mantisrx.connector.iceberg.sink.committer.config.CommitterConfig;
import io.mantisrx.connector.iceberg.sink.committer.watermarks.WatermarkExtractor;
import io.mantisrx.connector.iceberg.sink.writer.DefaultIcebergWriter;
import io.mantisrx.connector.iceberg.sink.writer.MantisDataFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCommitter {
    private static final Logger log = LoggerFactory.getLogger(IcebergCommitter.class);
    private final Table table;
    private final CommitterConfig config;
    private final WatermarkExtractor watermarkExtractor;

    public IcebergCommitter(Table table, CommitterConfig committerConfig, WatermarkExtractor watermarkExtractor) {
        this.table = table;
        this.config = committerConfig;
        this.watermarkExtractor = watermarkExtractor;
    }

    public Map<String, Object> commit(List<MantisDataFile> dataFiles) {
        Transaction transaction = this.table.newTransaction();
        AppendFiles tableAppender = transaction.newAppend();
        dataFiles.stream().map(MantisDataFile::getDataFile).forEach(arg_0 -> ((AppendFiles)tableAppender).appendFile(arg_0));
        tableAppender.commit();
        log.info("Iceberg committer {}.{} appended {} data files to transaction", new Object[]{this.config.getDatabase(), this.config.getTable(), dataFiles.size()});
        Long currentWatermark = this.watermarkExtractor.getWatermark(transaction);
        Long lowWatermark = null;
        for (MantisDataFile flinkDataFile : dataFiles) {
            lowWatermark = DefaultIcebergWriter.minNullSafe(lowWatermark, flinkDataFile.getLowWatermark());
        }
        Long finalWatermark = DefaultIcebergWriter.maxNullSafe(currentWatermark, lowWatermark);
        if (finalWatermark != null) {
            this.watermarkExtractor.setWatermark(transaction, finalWatermark);
        }
        transaction.commitTransaction();
        return this.table.currentSnapshot() == null ? new HashMap<String, Object>() : new HashMap(this.table.currentSnapshot().summary());
    }
}

