/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.codecs;

import io.mantisrx.common.codec.Codec;
import io.mantisrx.connector.iceberg.sink.writer.MantisDataFile;
import io.mantisrx.connector.iceberg.sink.writer.MantisRecord;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.IcebergDecoder;
import org.apache.iceberg.data.avro.IcebergEncoder;
import org.apache.iceberg.exceptions.RuntimeIOException;

public class IcebergCodecs {
    public static Codec<Record> record(Schema schema) {
        return new RecordCodec<Record>(schema);
    }

    public static Codec<MantisRecord> mantisRecord(Schema schema) {
        return new MantisRecordCodec(schema);
    }

    public static Codec<DataFile> dataFile() {
        return new ObjectCodec<DataFile>(DataFile.class);
    }

    public static Codec<MantisDataFile> mantisDataFile() {
        return new ObjectCodec<MantisDataFile>(MantisDataFile.class);
    }

    private static class ObjectCodec<T>
    implements Codec<T> {
        private final Class<T> tClass;

        private ObjectCodec(Class<T> tClass) {
            this.tClass = tClass;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T decode(byte[] bytes) {
            try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
                T t = this.tClass.cast(in.readObject());
                return t;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("Failed to convert bytes to DataFile", e);
            }
        }

        public byte[] encode(T value) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
                out.writeObject(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write bytes for DataFile: " + value, e);
            }
            return bytes.toByteArray();
        }
    }

    private static class RecordCodec<T>
    implements Codec<T> {
        private final IcebergEncoder<T> encoder;
        private final IcebergDecoder<T> decoder;

        private RecordCodec(Schema schema) {
            this.encoder = new IcebergEncoder(schema);
            this.decoder = new IcebergDecoder(schema);
        }

        public T decode(byte[] bytes) {
            try {
                return (T)this.decoder.decode(bytes);
            }
            catch (IOException e) {
                throw new RuntimeIOException("problem decoding Iceberg record", new Object[]{e});
            }
        }

        public byte[] encode(T value) {
            try {
                return this.encoder.encode(value).array();
            }
            catch (IOException e) {
                throw new RuntimeIOException("problem encoding encoding Iceberg record", new Object[]{e});
            }
        }
    }

    private static final class SerializableMantisRecord
    implements Serializable {
        private final byte[] record;
        @Nullable
        private final Long timestamp;

        @ConstructorProperties(value={"record", "timestamp"})
        public SerializableMantisRecord(byte[] record, @Nullable Long timestamp) {
            this.record = record;
            this.timestamp = timestamp;
        }

        public byte[] getRecord() {
            return this.record;
        }

        @Nullable
        public Long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializableMantisRecord)) {
                return false;
            }
            SerializableMantisRecord other = (SerializableMantisRecord)o;
            Long this$timestamp = this.getTimestamp();
            Long other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            return Arrays.equals(this.getRecord(), other.getRecord());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            result = result * 59 + Arrays.hashCode(this.getRecord());
            return result;
        }

        public String toString() {
            return "IcebergCodecs.SerializableMantisRecord(record=" + Arrays.toString(this.getRecord()) + ", timestamp=" + this.getTimestamp() + ")";
        }
    }

    private static class MantisRecordCodec
    implements Codec<MantisRecord> {
        private final IcebergEncoder<Record> encoder;
        private final IcebergDecoder<Record> decoder;
        private final ObjectCodec<SerializableMantisRecord> objectCodec;

        private MantisRecordCodec(Schema schema) {
            this.encoder = new IcebergEncoder(schema);
            this.decoder = new IcebergDecoder(schema);
            this.objectCodec = new ObjectCodec(SerializableMantisRecord.class);
        }

        public MantisRecord decode(byte[] bytes) {
            try {
                SerializableMantisRecord serializableMantisRecord = this.objectCodec.decode(bytes);
                return new MantisRecord((Record)this.decoder.decode(serializableMantisRecord.getRecord()), serializableMantisRecord.getTimestamp());
            }
            catch (IOException e) {
                throw new RuntimeIOException("problem decoding Iceberg record", new Object[]{e});
            }
        }

        public byte[] encode(MantisRecord value) {
            try {
                SerializableMantisRecord r = new SerializableMantisRecord(this.encoder.encode((Object)value.getRecord()).array(), value.getTimestamp());
                return this.objectCodec.encode(r);
            }
            catch (IOException e) {
                throw new RuntimeIOException("problem encoding encoding Iceberg record", new Object[]{e});
            }
        }
    }
}

