/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.writer.config;

import io.mantisrx.connector.iceberg.sink.config.SinkConfig;
import io.mantisrx.runtime.parameter.Parameters;
import org.apache.hadoop.conf.Configuration;

public class WriterConfig
extends SinkConfig {
    private final int writerRowGroupSize;
    private final long writerFlushFrequencyBytes;
    private final long writerFlushFrequencyMsec;
    private final String writerFileFormat;
    private final int writerMaximumPoolSize;
    private final Configuration hadoopConfig;

    public WriterConfig(Parameters parameters, Configuration hadoopConfig) {
        super(parameters);
        this.writerRowGroupSize = (Integer)parameters.get("writerRowGroupSize");
        this.writerFlushFrequencyBytes = Long.parseLong((String)parameters.get("writerFlushFrequencyBytes"));
        this.writerFlushFrequencyMsec = Long.parseLong((String)parameters.get("writerFlushFrequencyMsec"));
        this.writerFileFormat = (String)parameters.get("writerFileFormat");
        this.writerMaximumPoolSize = (Integer)parameters.get("writerMaximumPoolSize");
        this.hadoopConfig = hadoopConfig;
    }

    public WriterConfig(String catalog, String database, String table, int writerRowGroupSize, long writerFlushFrequencyBytes, long writerFlushFrequencyMsec, String writerFileFormat, int writerMaximumPoolSize, Configuration hadoopConfig) {
        super(catalog, database, table);
        this.writerRowGroupSize = writerRowGroupSize;
        this.writerFlushFrequencyBytes = writerFlushFrequencyBytes;
        this.writerFlushFrequencyMsec = writerFlushFrequencyMsec;
        this.writerFileFormat = writerFileFormat;
        this.writerMaximumPoolSize = writerMaximumPoolSize;
        this.hadoopConfig = hadoopConfig;
    }

    public int getWriterRowGroupSize() {
        return this.writerRowGroupSize;
    }

    public long getWriterFlushFrequencyBytes() {
        return this.writerFlushFrequencyBytes;
    }

    public long getWriterFlushFrequencyMsec() {
        return this.writerFlushFrequencyMsec;
    }

    public String getWriterFileFormat() {
        return this.writerFileFormat;
    }

    public int getWriterMaximumPoolSize() {
        return this.writerMaximumPoolSize;
    }

    public Configuration getHadoopConfig() {
        return this.hadoopConfig;
    }
}

