/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.iceberg.sink.codecs;

import io.mantisrx.common.codec.Codec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.IcebergDecoder;
import org.apache.iceberg.data.avro.IcebergEncoder;
import org.apache.iceberg.exceptions.RuntimeIOException;

public class IcebergCodecs {
    public static Codec<Record> record(Schema schema) {
        return new RecordCodec<Record>(schema);
    }

    public static Codec<DataFile> dataFile() {
        return new DataFileCodec();
    }

    private static class DataFileCodec
    implements Codec<DataFile> {
        private DataFileCodec() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public DataFile decode(byte[] bytes) {
            try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
                DataFile dataFile = (DataFile)in.readObject();
                return dataFile;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("Failed to convert bytes to DataFile", e);
            }
        }

        public byte[] encode(DataFile value) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
                out.writeObject(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write bytes for DataFile: " + value, e);
            }
            return bytes.toByteArray();
        }
    }

    private static class RecordCodec<T>
    implements Codec<T> {
        private final IcebergEncoder<T> encoder;
        private final IcebergDecoder<T> decoder;

        private RecordCodec(Schema schema) {
            this.encoder = new IcebergEncoder(schema);
            this.decoder = new IcebergDecoder(schema);
        }

        public T decode(byte[] bytes) {
            try {
                return (T)this.decoder.decode(bytes);
            }
            catch (IOException e) {
                throw new RuntimeIOException("problem decoding Iceberg record", new Object[]{e});
            }
        }

        public byte[] encode(T value) {
            try {
                return this.encoder.encode(value).array();
            }
            catch (IOException e) {
                throw new RuntimeIOException("problem encoding encoding Iceberg record", new Object[]{e});
            }
        }
    }
}

