/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.BaseSpscLinkedArrayQueue;
import org.jctools.queues.CircularArrayOffsetCalculator;
import org.jctools.queues.SpscArrayQueue;
import org.jctools.util.Pow2;
import org.jctools.util.UnsafeRefArrayAccess;

public class SpscUnboundedArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    public SpscUnboundedArrayQueue(int chunkSize) {
        int p2capacity = Math.max(Pow2.roundToPowerOfTwo(chunkSize), 16);
        long mask = p2capacity - 1;
        Object[] buffer = new Object[p2capacity + 1];
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.producerLookAheadStep = Math.min(p2capacity / 4, SpscArrayQueue.MAX_LOOK_AHEAD_STEP);
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerLimit = mask - 1L;
        this.soProducerIndex(0L);
    }

    @Override
    protected boolean offerColdPath(E[] buffer, long mask, E e2, long index2, long offset) {
        int lookAheadStep = this.producerLookAheadStep;
        long lookAheadElementOffset = CircularArrayOffsetCalculator.calcElementOffset(index2 + (long)lookAheadStep, mask);
        if (null == UnsafeRefArrayAccess.lvElement(buffer, lookAheadElementOffset)) {
            this.producerLimit = index2 + (long)lookAheadStep - 1L;
            this.writeToQueue(buffer, e2, index2, offset);
        } else if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(index2 + 1L, mask))) {
            this.writeToQueue(buffer, e2, index2, offset);
        } else {
            this.linkNewBuffer(buffer, index2, offset, e2, mask);
        }
        return true;
    }

    private void linkNewBuffer(E[] oldBuffer, long currIndex, long offset, E e2, long mask) {
        Object[] newBuffer = new Object[oldBuffer.length];
        this.producerBuffer = newBuffer;
        this.producerLimit = currIndex + mask - 1L;
        UnsafeRefArrayAccess.soElement(newBuffer, offset, e2);
        this.soNext(oldBuffer, newBuffer);
        UnsafeRefArrayAccess.soElement(oldBuffer, offset, JUMP);
        this.soProducerIndex(currIndex + 1L);
    }
}

