/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.remote.observable;

import io.mantisrx.common.codec.Decoder;
import io.reactivex.mantis.remote.observable.ConnectToConfig;
import java.util.HashMap;
import java.util.Map;
import rx.functions.Action0;
import rx.functions.Action2;
import rx.subjects.PublishSubject;

public class ConnectToObservable<T>
extends ConnectToConfig {
    private Decoder<T> decoder;
    private Action2<T, Throwable> deocdingErrorHandler;

    ConnectToObservable(Builder<T> builder) {
        super(((Builder)builder).host, ((Builder)builder).port, ((Builder)builder).name, ((Builder)builder).subscribeParameters, ((Builder)builder).subscribeRetryAttempts, ((Builder)builder).suppressDecodingErrors, ((Builder)builder).connectionDisconnectCallback, ((Builder)builder).closeTrigger);
        this.decoder = ((Builder)builder).decoder;
        this.deocdingErrorHandler = ((Builder)builder).deocdingErrorHandler;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public Action2<T, Throwable> getDeocdingErrorHandler() {
        return this.deocdingErrorHandler;
    }

    public static class Builder<T> {
        private String host;
        private int port;
        private String name;
        private Decoder<T> decoder;
        private Map<String, String> subscribeParameters = new HashMap<String, String>();
        private int subscribeRetryAttempts = 3;
        private Action2<T, Throwable> deocdingErrorHandler = new Action2<T, Throwable>(this){
            final /* synthetic */ Builder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void call(T t1, Throwable t2) {
                t2.printStackTrace();
            }
        };
        private boolean suppressDecodingErrors = false;
        private Action0 connectionDisconnectCallback = new Action0(this){
            final /* synthetic */ Builder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void call() {
            }
        };
        private PublishSubject<Integer> closeTrigger = PublishSubject.create();

        public Builder() {
        }

        public Builder(Builder<T> config) {
            this.host = config.host;
            this.port = config.port;
            this.name = config.name;
            this.decoder = config.decoder;
            this.subscribeParameters.putAll(config.subscribeParameters);
            this.subscribeRetryAttempts = config.subscribeRetryAttempts;
            this.deocdingErrorHandler = config.deocdingErrorHandler;
            this.suppressDecodingErrors = config.suppressDecodingErrors;
        }

        public Builder<T> host(String host) {
            this.host = host;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> closeTrigger(PublishSubject<Integer> closeTrigger) {
            this.closeTrigger = closeTrigger;
            return this;
        }

        public Builder<T> connectionDisconnectCallback(Action0 connectionDisconnectCallback) {
            this.connectionDisconnectCallback = connectionDisconnectCallback;
            return this;
        }

        public Builder<T> deocdingErrorHandler(Action2<T, Throwable> handler, boolean suppressDecodingErrors) {
            this.deocdingErrorHandler = handler;
            this.suppressDecodingErrors = suppressDecodingErrors;
            return this;
        }

        public Builder<T> name(String name2) {
            this.name = name2;
            this.subscribeParameters.put("groupId", name2);
            return this;
        }

        public Builder<T> slotId(String slotId) {
            this.subscribeParameters.put("slotId", slotId);
            return this;
        }

        public Builder<T> decoder(Decoder<T> decoder) {
            this.decoder = decoder;
            return this;
        }

        public Builder<T> subscribeParameters(Map<String, String> subscribeParameters) {
            this.subscribeParameters.putAll(subscribeParameters);
            return this;
        }

        public Builder<T> subscribeAttempts(int subscribeAttempts) {
            this.subscribeRetryAttempts = subscribeAttempts;
            return this;
        }

        public ConnectToObservable<T> build() {
            return new ConnectToObservable(this);
        }
    }
}

