/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;
import java.util.Locale;

public abstract class AbstractSniHandler<T>
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final int MAX_SSL_RECORDS = 4;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractSniHandler.class);
    private boolean handshakeFailed;
    private boolean suppressRead;
    private boolean readPending;

    /*
     * Unable to fully structure code
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!this.suppressRead && !this.handshakeFailed) {
            block18: {
                writerIndex = in.writerIndex();
                try {
                    block8: for (i = 0; i < 4; ++i) {
                        readerIndex = in.readerIndex();
                        readableBytes = writerIndex - readerIndex;
                        if (readableBytes < 5) {
                            return;
                        }
                        command = in.getUnsignedByte(readerIndex);
                        switch (command) {
                            case 20: 
                            case 21: {
                                len = SslUtils.getEncryptedPacketLength(in, readerIndex);
                                if (len == -2) {
                                    this.handshakeFailed = true;
                                    e = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(in));
                                    in.skipBytes(in.readableBytes());
                                    SslUtils.notifyHandshakeFailure(ctx, e);
                                    throw e;
                                }
                                if (len == -1 || writerIndex - readerIndex - 5 < len) {
                                    return;
                                }
                                in.skipBytes(len);
                                continue block8;
                            }
                            case 22: {
                                majorVersion = in.getUnsignedByte(readerIndex + 1);
                                if (majorVersion == 3) {
                                    packetLength = in.getUnsignedShort(readerIndex + 3) + 5;
                                    if (readableBytes < packetLength) {
                                        return;
                                    }
                                    endOffset = readerIndex + packetLength;
                                    offset = readerIndex + 43;
                                    if (endOffset - offset < 6) break block18;
                                    sessionIdLength = in.getUnsignedByte(offset);
                                    cipherSuitesLength = in.getUnsignedShort(offset += sessionIdLength + 1);
                                    compressionMethodLength = in.getUnsignedByte(offset += cipherSuitesLength + 2);
                                    offset += compressionMethodLength + 1;
                                    ** if ((extensionsLimit = (offset += 2) + (extensionsLength = in.getUnsignedShort((int)offset))) > endOffset) goto lbl57
                                    while (extensionsLimit - offset >= 4) {
                                        extensionType = in.getUnsignedShort(offset);
                                        offset += 2;
                                        if (extensionsLimit - (offset += 2) < (extensionLength = in.getUnsignedShort(offset))) break block18;
                                        if (extensionType == 0) {
                                            if (extensionsLimit - (offset += 2) < 3) break block18;
                                            serverNameType = in.getUnsignedByte(offset);
                                            ++offset;
                                            if (serverNameType != 0 || extensionsLimit - (offset += 2) < (serverNameLength = in.getUnsignedShort(offset))) break block18;
                                            hostname = in.toString(offset, serverNameLength, CharsetUtil.US_ASCII);
                                            try {
                                                this.select(ctx, hostname.toLowerCase(Locale.US));
                                            }
                                            catch (Throwable t) {
                                                PlatformDependent.throwException(t);
                                            }
                                            return;
                                        }
                                        offset += extensionLength;
lbl-1000:
                                        // 2 sources

                                        {
                                        }
                                    }
lbl57:
                                    // 2 sources

                                    break block18;
                                }
                            }
                            default: {
                                break block18;
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    if (!AbstractSniHandler.logger.isDebugEnabled()) break block18;
                    AbstractSniHandler.logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump(in), e);
                }
            }
            this.select(ctx, null);
        }
    }

    private void select(final ChannelHandlerContext ctx, final String hostname) throws Exception {
        Future<T> future2 = this.lookup(ctx, hostname);
        if (future2.isDone()) {
            this.onLookupComplete(ctx, hostname, future2);
        } else {
            this.suppressRead = true;
            future2.addListener(new FutureListener<T>(){

                @Override
                public void operationComplete(Future<T> future2) throws Exception {
                    try {
                        AbstractSniHandler.this.suppressRead = false;
                        try {
                            AbstractSniHandler.this.onLookupComplete(ctx, hostname, future2);
                        }
                        catch (DecoderException err) {
                            ctx.fireExceptionCaught(err);
                        }
                        catch (Exception cause) {
                            ctx.fireExceptionCaught(new DecoderException(cause));
                        }
                        catch (Throwable cause) {
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                    finally {
                        if (AbstractSniHandler.this.readPending) {
                            AbstractSniHandler.this.readPending = false;
                            ctx.read();
                        }
                    }
                }
            });
        }
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, String var2) throws Exception;

    protected abstract void onLookupComplete(ChannelHandlerContext var1, String var2, Future<T> var3) throws Exception;

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        if (this.suppressRead) {
            this.readPending = true;
        } else {
            ctx.read();
        }
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise2) throws Exception {
        ctx.bind(localAddress, promise2);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise2) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise2);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise2) throws Exception {
        ctx.disconnect(promise2);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise2) throws Exception {
        ctx.close(promise2);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise2) throws Exception {
        ctx.deregister(promise2);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise2) throws Exception {
        ctx.write(msg, promise2);
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

