/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.http.multipart;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.multipart.Attribute;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.multipart.DiskAttribute;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.multipart.MemoryAttribute;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class MixedAttribute
implements Attribute {
    private Attribute attribute;
    private final long limitSize;

    public MixedAttribute(String name2, long limitSize) {
        this.limitSize = limitSize;
        this.attribute = new MemoryAttribute(name2);
    }

    public MixedAttribute(String name2, String value, long limitSize) {
        this.limitSize = limitSize;
        if ((long)value.length() > this.limitSize) {
            try {
                this.attribute = new DiskAttribute(name2, value);
            }
            catch (IOException e2) {
                try {
                    this.attribute = new MemoryAttribute(name2, value);
                }
                catch (IOException e1) {
                    throw new IllegalArgumentException(e2);
                }
            }
        } else {
            try {
                this.attribute = new MemoryAttribute(name2, value);
            }
            catch (IOException e3) {
                throw new IllegalArgumentException(e3);
            }
        }
    }

    public void addContent(ChannelBuffer buffer, boolean last2) throws IOException {
        if (this.attribute instanceof MemoryAttribute && this.attribute.length() + (long)buffer.readableBytes() > this.limitSize) {
            DiskAttribute diskAttribute = new DiskAttribute(this.attribute.getName());
            if (((MemoryAttribute)this.attribute).getChannelBuffer() != null) {
                diskAttribute.addContent(((MemoryAttribute)this.attribute).getChannelBuffer(), false);
            }
            this.attribute = diskAttribute;
        }
        this.attribute.addContent(buffer, last2);
    }

    public void delete() {
        this.attribute.delete();
    }

    public byte[] get() throws IOException {
        return this.attribute.get();
    }

    public ChannelBuffer getChannelBuffer() throws IOException {
        return this.attribute.getChannelBuffer();
    }

    public Charset getCharset() {
        return this.attribute.getCharset();
    }

    public String getString() throws IOException {
        return this.attribute.getString();
    }

    public String getString(Charset encoding2) throws IOException {
        return this.attribute.getString(encoding2);
    }

    public boolean isCompleted() {
        return this.attribute.isCompleted();
    }

    public boolean isInMemory() {
        return this.attribute.isInMemory();
    }

    public long length() {
        return this.attribute.length();
    }

    public boolean renameTo(File dest) throws IOException {
        return this.attribute.renameTo(dest);
    }

    public void setCharset(Charset charset) {
        this.attribute.setCharset(charset);
    }

    public void setContent(ChannelBuffer buffer) throws IOException {
        if ((long)buffer.readableBytes() > this.limitSize && this.attribute instanceof MemoryAttribute) {
            this.attribute = new DiskAttribute(this.attribute.getName());
        }
        this.attribute.setContent(buffer);
    }

    public void setContent(File file2) throws IOException {
        if (file2.length() > this.limitSize && this.attribute instanceof MemoryAttribute) {
            this.attribute = new DiskAttribute(this.attribute.getName());
        }
        this.attribute.setContent(file2);
    }

    public void setContent(InputStream inputStream) throws IOException {
        if (this.attribute instanceof MemoryAttribute) {
            this.attribute = new DiskAttribute(this.attribute.getName());
        }
        this.attribute.setContent(inputStream);
    }

    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return this.attribute.getHttpDataType();
    }

    public String getName() {
        return this.attribute.getName();
    }

    public int compareTo(InterfaceHttpData o) {
        return this.attribute.compareTo(o);
    }

    public String toString() {
        return "Mixed: " + this.attribute.toString();
    }

    public String getValue() throws IOException {
        return this.attribute.getValue();
    }

    public void setValue(String value) throws IOException {
        this.attribute.setValue(value);
    }

    public ChannelBuffer getChunk(int length) throws IOException {
        return this.attribute.getChunk(length);
    }

    public File getFile() throws IOException {
        return this.attribute.getFile();
    }
}

