/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.fasterxml.jackson.databind.deser;

import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.BeanDescription;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.introspect.Annotated;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.ArrayType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.CollectionLikeType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.CollectionType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.MapType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.type.ReferenceType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.util.ClassUtil;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.util.Converter;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;
import java.util.HashMap;

public final class DeserializerCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final LRUMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers;
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers = new HashMap(8);

    public DeserializerCache() {
        this(2000);
    }

    public DeserializerCache(int maxSize) {
        int initial = Math.min(64, maxSize >> 2);
        this._cachedDeserializers = new LRUMap(initial, maxSize);
    }

    Object writeReplace() {
        this._incompleteDeserializers.clear();
        return this;
    }

    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    public JsonDeserializer<Object> findValueDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType propertyType) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(propertyType);
        if (deser == null && (deser = this._createAndCacheValueDeserializer(ctxt, factory, propertyType)) == null) {
            deser = this._handleUnknownValueDeserializer(ctxt, propertyType);
        }
        return deser;
    }

    public KeyDeserializer findKeyDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2) throws JsonMappingException {
        KeyDeserializer kd = factory.createKeyDeserializer(ctxt, type2);
        if (kd == null) {
            return this._handleUnknownKeyDeserializer(ctxt, type2);
        }
        if (kd instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)kd)).resolve(ctxt);
        }
        return kd;
    }

    public boolean hasValueDeserializerFor(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(type2);
        if (deser == null) {
            deser = this._createAndCacheValueDeserializer(ctxt, factory, type2);
        }
        return deser != null;
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException("Null JavaType passed");
        }
        if (this._hasCustomHandlers(type2)) {
            return null;
        }
        return this._cachedDeserializers.get(type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2) throws JsonMappingException {
        HashMap<JavaType, JsonDeserializer<Object>> hashMap = this._incompleteDeserializers;
        synchronized (hashMap) {
            JsonDeserializer<Object> jsonDeserializer;
            block9: {
                JsonDeserializer<Object> deser = this._findCachedDeserializer(type2);
                if (deser != null) {
                    return deser;
                }
                int count2 = this._incompleteDeserializers.size();
                if (count2 > 0 && (deser = this._incompleteDeserializers.get(type2)) != null) {
                    return deser;
                }
                try {
                    jsonDeserializer = this._createAndCache2(ctxt, factory, type2);
                    if (count2 != 0 || this._incompleteDeserializers.size() <= 0) break block9;
                    this._incompleteDeserializers.clear();
                }
                catch (Throwable throwable) {
                    if (count2 == 0 && this._incompleteDeserializers.size() > 0) {
                        this._incompleteDeserializers.clear();
                    }
                    throw throwable;
                }
            }
            return jsonDeserializer;
        }
    }

    protected JsonDeserializer<Object> _createAndCache2(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2) throws JsonMappingException {
        boolean addToCache;
        JsonDeserializer<Object> deser;
        try {
            deser = this._createDeserializer(ctxt, factory, type2);
        }
        catch (IllegalArgumentException iae) {
            throw JsonMappingException.from(ctxt, ClassUtil.exceptionMessage(iae), (Throwable)iae);
        }
        if (deser == null) {
            return null;
        }
        boolean bl = addToCache = !this._hasCustomHandlers(type2) && deser.isCachable();
        if (deser instanceof ResolvableDeserializer) {
            this._incompleteDeserializers.put(type2, deser);
            ((ResolvableDeserializer)((Object)deser)).resolve(ctxt);
            this._incompleteDeserializers.remove(type2);
        }
        if (addToCache) {
            this._cachedDeserializers.put(type2, deser);
        }
        return deser;
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2) throws JsonMappingException {
        Class<?> builder;
        BeanDescription beanDesc;
        JsonDeserializer<Object> deser;
        DeserializationConfig config = ctxt.getConfig();
        if (type2.isAbstract() || type2.isMapLikeType() || type2.isCollectionLikeType()) {
            type2 = factory.mapAbstractType(config, type2);
        }
        if ((deser = this.findDeserializerFromAnnotation(ctxt, (beanDesc = config.introspect(type2)).getClassInfo())) != null) {
            return deser;
        }
        JavaType newType = this.modifyTypeByAnnotation(ctxt, beanDesc.getClassInfo(), type2);
        if (newType != type2) {
            type2 = newType;
            beanDesc = config.introspect(newType);
        }
        if ((builder = beanDesc.findPOJOBuilder()) != null) {
            return factory.createBuilderBasedDeserializer(ctxt, type2, beanDesc, builder);
        }
        Converter<Object, Object> conv = beanDesc.findDeserializationConverter();
        if (conv == null) {
            return this._createDeserializer2(ctxt, factory, type2, beanDesc);
        }
        JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
        if (!delegateType.hasRawClass(type2.getRawClass())) {
            beanDesc = config.introspect(delegateType);
        }
        return new StdDelegatingDeserializer<Object>(conv, delegateType, this._createDeserializer2(ctxt, factory, delegateType, beanDesc));
    }

    protected JsonDeserializer<?> _createDeserializer2(DeserializationContext ctxt, DeserializerFactory factory, JavaType type2, BeanDescription beanDesc) throws JsonMappingException {
        DeserializationConfig config = ctxt.getConfig();
        if (type2.isEnumType()) {
            return factory.createEnumDeserializer(ctxt, type2, beanDesc);
        }
        if (type2.isContainerType()) {
            JsonFormat.Value format2;
            if (type2.isArrayType()) {
                return factory.createArrayDeserializer(ctxt, (ArrayType)type2, beanDesc);
            }
            if (type2.isMapLikeType() && (format2 = beanDesc.findExpectedFormat(null)).getShape() != JsonFormat.Shape.OBJECT) {
                MapLikeType mlt = (MapLikeType)type2;
                if (mlt instanceof MapType) {
                    return factory.createMapDeserializer(ctxt, (MapType)mlt, beanDesc);
                }
                return factory.createMapLikeDeserializer(ctxt, mlt, beanDesc);
            }
            if (type2.isCollectionLikeType() && (format2 = beanDesc.findExpectedFormat(null)).getShape() != JsonFormat.Shape.OBJECT) {
                CollectionLikeType clt = (CollectionLikeType)type2;
                if (clt instanceof CollectionType) {
                    return factory.createCollectionDeserializer(ctxt, (CollectionType)clt, beanDesc);
                }
                return factory.createCollectionLikeDeserializer(ctxt, clt, beanDesc);
            }
        }
        if (type2.isReferenceType()) {
            return factory.createReferenceDeserializer(ctxt, (ReferenceType)type2, beanDesc);
        }
        if (JsonNode.class.isAssignableFrom(type2.getRawClass())) {
            return factory.createTreeDeserializer(config, type2, beanDesc);
        }
        return factory.createBeanDeserializer(ctxt, type2, beanDesc);
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext ctxt, Annotated ann) throws JsonMappingException {
        Object deserDef = ctxt.getAnnotationIntrospector().findDeserializer(ann);
        if (deserDef == null) {
            return null;
        }
        JsonDeserializer<Object> deser = ctxt.deserializerInstance(ann, deserDef);
        return this.findConvertingDeserializer(ctxt, ann, deser);
    }

    protected JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext ctxt, Annotated a, JsonDeserializer<Object> deser) throws JsonMappingException {
        Converter<Object, Object> conv = this.findConverter(ctxt, a);
        if (conv == null) {
            return deser;
        }
        JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
        return new StdDelegatingDeserializer<Object>(conv, delegateType, deser);
    }

    protected Converter<Object, Object> findConverter(DeserializationContext ctxt, Annotated a) throws JsonMappingException {
        Object convDef = ctxt.getAnnotationIntrospector().findDeserializationConverter(a);
        if (convDef == null) {
            return null;
        }
        return ctxt.converterInstance(a, convDef);
    }

    private JavaType modifyTypeByAnnotation(DeserializationContext ctxt, Annotated a, JavaType type2) throws JsonMappingException {
        Object cdDef;
        JavaType contentType;
        KeyDeserializer kd;
        Object kdDef;
        JavaType keyType;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr == null) {
            return type2;
        }
        if (type2.isMapLikeType() && (keyType = type2.getKeyType()) != null && keyType.getValueHandler() == null && (kdDef = intr.findKeyDeserializer(a)) != null && (kd = ctxt.keyDeserializerInstance(a, kdDef)) != null) {
            type2 = ((MapLikeType)type2).withKeyValueHandler(kd);
        }
        if ((contentType = type2.getContentType()) != null && contentType.getValueHandler() == null && (cdDef = intr.findContentDeserializer(a)) != null) {
            JsonDeserializer<Object> cd = null;
            if (cdDef instanceof JsonDeserializer) {
                cd = (JsonDeserializer<Object>)cdDef;
            } else {
                Class<?> cdClass = this._verifyAsClass(cdDef, "findContentDeserializer", JsonDeserializer.None.class);
                if (cdClass != null) {
                    cd = ctxt.deserializerInstance(a, cdClass);
                }
            }
            if (cd != null) {
                type2 = type2.withContentValueHandler(cd);
            }
        }
        type2 = intr.refineDeserializationType(ctxt.getConfig(), a, type2);
        return type2;
    }

    private boolean _hasCustomHandlers(JavaType t) {
        if (t.isContainerType()) {
            JavaType kt;
            JavaType ct = t.getContentType();
            if (ct != null && (ct.getValueHandler() != null || ct.getTypeHandler() != null)) {
                return true;
            }
            if (t.isMapLikeType() && (kt = t.getKeyType()).getValueHandler() != null) {
                return true;
            }
        }
        return false;
    }

    private Class<?> _verifyAsClass(Object src, String methodName, Class<?> noneClass) {
        if (src == null) {
            return null;
        }
        if (!(src instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + methodName + "() returned value of type " + src.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class cls = (Class)src;
        if (cls == noneClass || ClassUtil.isBogusClass(cls)) {
            return null;
        }
        return cls;
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(DeserializationContext ctxt, JavaType type2) throws JsonMappingException {
        Class<?> rawClass = type2.getRawClass();
        if (!ClassUtil.isConcrete(rawClass)) {
            return (JsonDeserializer)ctxt.reportBadDefinition(type2, "Cannot find a Value deserializer for abstract type " + type2);
        }
        return (JsonDeserializer)ctxt.reportBadDefinition(type2, "Cannot find a Value deserializer for type " + type2);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(DeserializationContext ctxt, JavaType type2) throws JsonMappingException {
        return (KeyDeserializer)ctxt.reportBadDefinition(type2, "Cannot find a (Map) Key deserializer for type " + type2);
    }
}

