/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.mantis.network.push;

import io.mantisrx.common.metrics.MetricsRegistry;
import io.reactivex.mantis.network.push.ChunkProcessor;
import io.reactivex.mantis.network.push.GroupChunkProcessor;
import io.reactivex.mantis.network.push.Router;
import java.util.List;
import java.util.Map;
import rx.functions.Func1;

public class ServerConfig<T> {
    private String name;
    private int port;
    private int numQueueConsumers = 1;
    private int bufferCapacity = 100;
    private int writeRetryCount = 2;
    private int maxChunkSize = 25;
    private int maxChunkTimeMSec = 100;
    private int maxNotWritableTimeSec = -1;
    private ChunkProcessor<T> chunkProcessor;
    private MetricsRegistry metricsRegistry;
    private Func1<Map<String, List<String>>, Func1<T, Boolean>> predicate;
    private boolean useSpscQueue = false;

    public ServerConfig(Builder<T> builder) {
        this.name = ((Builder)builder).name;
        this.port = ((Builder)builder).port;
        this.bufferCapacity = ((Builder)builder).bufferCapacity;
        this.writeRetryCount = ((Builder)builder).writeRetryCount;
        this.maxChunkSize = ((Builder)builder).maxChunkSize;
        this.maxChunkTimeMSec = ((Builder)builder).maxChunkTimeMSec;
        this.chunkProcessor = ((Builder)builder).chunkProcessor;
        this.metricsRegistry = ((Builder)builder).metricsRegistry;
        this.numQueueConsumers = ((Builder)builder).numQueueConsumers;
        this.predicate = ((Builder)builder).predicate;
        this.useSpscQueue = ((Builder)builder).useSpscQueue;
        this.maxNotWritableTimeSec = ((Builder)builder).maxNotWritableTimeSec;
    }

    public Func1<Map<String, List<String>>, Func1<T, Boolean>> getPredicate() {
        return this.predicate;
    }

    public int getNumQueueConsumers() {
        return this.numQueueConsumers;
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public int getWriteRetryCount() {
        return this.writeRetryCount;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getMaxChunkTimeMSec() {
        return this.maxChunkTimeMSec;
    }

    public int getMaxNotWritableTimeSec() {
        return this.maxNotWritableTimeSec;
    }

    public ChunkProcessor<T> getChunkProcessor() {
        return this.chunkProcessor;
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public boolean useSpscQueue() {
        return this.useSpscQueue;
    }

    public static class Builder<T> {
        private String name;
        private int port;
        private int numQueueConsumers = 1;
        private int bufferCapacity = 100;
        private int writeRetryCount = 2;
        private int maxChunkSize = 25;
        private int maxChunkTimeMSec = 100;
        private int maxNotWritableTimeSec = -1;
        private ChunkProcessor<T> chunkProcessor;
        private MetricsRegistry metricsRegistry;
        private Func1<Map<String, List<String>>, Func1<T, Boolean>> predicate;
        private boolean useSpscQueue = false;

        public Builder<T> predicate(Func1<Map<String, List<String>>, Func1<T, Boolean>> predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder<T> name(String name2) {
            this.name = name2;
            return this;
        }

        public Builder<T> bufferCapacity(int bufferCapacity) {
            this.bufferCapacity = bufferCapacity;
            return this;
        }

        public Builder<T> useSpscQueue(boolean useSpsc) {
            this.useSpscQueue = useSpsc;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> numQueueConsumers(int numQueueConsumers) {
            this.numQueueConsumers = numQueueConsumers;
            return this;
        }

        public Builder<T> writeRetryCount(int writeRetryCount) {
            this.writeRetryCount = writeRetryCount;
            return this;
        }

        public Builder<T> maxChunkSize(int maxChunkSize) {
            this.maxChunkSize = maxChunkSize;
            return this;
        }

        public Builder<T> maxChunkTimeMSec(int maxChunkTimeMSec) {
            this.maxChunkTimeMSec = maxChunkTimeMSec;
            return this;
        }

        public Builder<T> maxNotWritableTimeSec(int maxNotWritableTimeSec) {
            this.maxNotWritableTimeSec = maxNotWritableTimeSec;
            return this;
        }

        public Builder<T> groupRouter(Router<T> router) {
            this.chunkProcessor = new GroupChunkProcessor<T>(router);
            return this;
        }

        public Builder<T> router(Router<T> router) {
            this.chunkProcessor = new ChunkProcessor<T>(router);
            return this;
        }

        public Builder<T> metricsRegistry(MetricsRegistry metricsRegistry) {
            this.metricsRegistry = metricsRegistry;
            return this;
        }

        public ServerConfig<T> build() {
            return new ServerConfig(this);
        }
    }
}

