/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy;

import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpMethod;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpdyHeaders {
    private static final int BUCKET_SIZE = 17;
    private final HeaderEntry[] entries = new HeaderEntry[17];
    private final HeaderEntry head;

    public static String getHeader(SpdyHeadersFrame frame, String name2) {
        return frame.getHeader(name2);
    }

    public static String getHeader(SpdyHeadersFrame frame, String name2, String defaultValue) {
        String value = frame.getHeader(name2);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void setHeader(SpdyHeadersFrame frame, String name2, Object value) {
        frame.setHeader(name2, value);
    }

    public static void setHeader(SpdyHeadersFrame frame, String name2, Iterable<?> values) {
        frame.setHeader(name2, values);
    }

    public static void addHeader(SpdyHeadersFrame frame, String name2, Object value) {
        frame.addHeader(name2, value);
    }

    public static void removeHost(SpdyHeadersFrame frame) {
        frame.removeHeader(":host");
    }

    public static String getHost(SpdyHeadersFrame frame) {
        return frame.getHeader(":host");
    }

    public static void setHost(SpdyHeadersFrame frame, String host) {
        frame.setHeader(":host", host);
    }

    public static void removeMethod(int spdyVersion, SpdyHeadersFrame frame) {
        if (spdyVersion < 3) {
            frame.removeHeader("method");
        } else {
            frame.removeHeader(":method");
        }
    }

    public static HttpMethod getMethod(int spdyVersion, SpdyHeadersFrame frame) {
        try {
            if (spdyVersion < 3) {
                return HttpMethod.valueOf(frame.getHeader("method"));
            }
            return HttpMethod.valueOf(frame.getHeader(":method"));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void setMethod(int spdyVersion, SpdyHeadersFrame frame, HttpMethod method) {
        if (spdyVersion < 3) {
            frame.setHeader("method", method.getName());
        } else {
            frame.setHeader(":method", method.getName());
        }
    }

    public static void removeScheme(int spdyVersion, SpdyHeadersFrame frame) {
        if (spdyVersion < 2) {
            frame.removeHeader("scheme");
        } else {
            frame.removeHeader(":scheme");
        }
    }

    public static String getScheme(int spdyVersion, SpdyHeadersFrame frame) {
        if (spdyVersion < 3) {
            return frame.getHeader("scheme");
        }
        return frame.getHeader(":scheme");
    }

    public static void setScheme(int spdyVersion, SpdyHeadersFrame frame, String scheme) {
        if (spdyVersion < 3) {
            frame.setHeader("scheme", scheme);
        } else {
            frame.setHeader(":scheme", scheme);
        }
    }

    public static void removeStatus(int spdyVersion, SpdyHeadersFrame frame) {
        if (spdyVersion < 3) {
            frame.removeHeader("status");
        } else {
            frame.removeHeader(":status");
        }
    }

    public static HttpResponseStatus getStatus(int spdyVersion, SpdyHeadersFrame frame) {
        try {
            String status = spdyVersion < 3 ? frame.getHeader("status") : frame.getHeader(":status");
            int space = status.indexOf(32);
            if (space == -1) {
                return HttpResponseStatus.valueOf(Integer.parseInt(status));
            }
            int code = Integer.parseInt(status.substring(0, space));
            String reasonPhrase = status.substring(space + 1);
            HttpResponseStatus responseStatus = HttpResponseStatus.valueOf(code);
            if (responseStatus.getReasonPhrase().equals(reasonPhrase)) {
                return responseStatus;
            }
            return new HttpResponseStatus(code, reasonPhrase);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void setStatus(int spdyVersion, SpdyHeadersFrame frame, HttpResponseStatus status) {
        if (spdyVersion < 3) {
            frame.setHeader("status", status.toString());
        } else {
            frame.setHeader(":status", status.toString());
        }
    }

    public static void removeUrl(int spdyVersion, SpdyHeadersFrame frame) {
        if (spdyVersion < 3) {
            frame.removeHeader("url");
        } else {
            frame.removeHeader(":path");
        }
    }

    public static String getUrl(int spdyVersion, SpdyHeadersFrame frame) {
        if (spdyVersion < 3) {
            return frame.getHeader("url");
        }
        return frame.getHeader(":path");
    }

    public static void setUrl(int spdyVersion, SpdyHeadersFrame frame, String path2) {
        if (spdyVersion < 3) {
            frame.setHeader("url", path2);
        } else {
            frame.setHeader(":path", path2);
        }
    }

    public static void removeVersion(int spdyVersion, SpdyHeadersFrame frame) {
        if (spdyVersion < 3) {
            frame.removeHeader("version");
        } else {
            frame.removeHeader(":version");
        }
    }

    public static HttpVersion getVersion(int spdyVersion, SpdyHeadersFrame frame) {
        try {
            if (spdyVersion < 3) {
                return HttpVersion.valueOf(frame.getHeader("version"));
            }
            return HttpVersion.valueOf(frame.getHeader(":version"));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void setVersion(int spdyVersion, SpdyHeadersFrame frame, HttpVersion httpVersion) {
        if (spdyVersion < 3) {
            frame.setHeader("version", httpVersion.getText());
        } else {
            frame.setHeader(":version", httpVersion.getText());
        }
    }

    private static int hash(String name2) {
        int h = 0;
        for (int i = name2.length() - 1; i >= 0; --i) {
            char c = name2.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    private static boolean eq(String name1, String name2) {
        int nameLen = name1.length();
        if (nameLen != name2.length()) {
            return false;
        }
        for (int i = nameLen - 1; i >= 0; --i) {
            char c2;
            char c1 = name1.charAt(i);
            if (c1 == (c2 = name2.charAt(i))) continue;
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    private static int index(int hash2) {
        return hash2 % 17;
    }

    SpdyHeaders() {
        this.head.before = this.head.after = (this.head = new HeaderEntry(-1, null, null));
    }

    void addHeader(String name2, Object value) {
        String lowerCaseName = name2.toLowerCase();
        SpdyCodecUtil.validateHeaderName(lowerCaseName);
        String strVal = SpdyHeaders.toString(value);
        SpdyCodecUtil.validateHeaderValue(strVal);
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.addHeader0(h, i, lowerCaseName, strVal);
    }

    private void addHeader0(int h, int i, String name2, String value) {
        HeaderEntry newEntry;
        HeaderEntry e2 = this.entries[i];
        this.entries[i] = newEntry = new HeaderEntry(h, name2, value);
        newEntry.next = e2;
        newEntry.addBefore(this.head);
    }

    void removeHeader(String name2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        String lowerCaseName = name2.toLowerCase();
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.removeHeader0(h, i, lowerCaseName);
    }

    private void removeHeader0(int h, int i, String name2) {
        HeaderEntry next2;
        HeaderEntry e2 = this.entries[i];
        if (e2 == null) {
            return;
        }
        while (e2.hash == h && SpdyHeaders.eq(name2, e2.key)) {
            e2.remove();
            next2 = e2.next;
            if (next2 != null) {
                this.entries[i] = next2;
                e2 = next2;
                continue;
            }
            this.entries[i] = null;
            return;
        }
        while ((next2 = e2.next) != null) {
            if (next2.hash == h && SpdyHeaders.eq(name2, next2.key)) {
                e2.next = next2.next;
                next2.remove();
                continue;
            }
            e2 = next2;
        }
    }

    void setHeader(String name2, Object value) {
        String lowerCaseName = name2.toLowerCase();
        SpdyCodecUtil.validateHeaderName(lowerCaseName);
        String strVal = SpdyHeaders.toString(value);
        SpdyCodecUtil.validateHeaderValue(strVal);
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.removeHeader0(h, i, lowerCaseName);
        this.addHeader0(h, i, lowerCaseName, strVal);
    }

    void setHeader(String name2, Iterable<?> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        String lowerCaseName = name2.toLowerCase();
        SpdyCodecUtil.validateHeaderName(lowerCaseName);
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.removeHeader0(h, i, lowerCaseName);
        for (Object v : values) {
            if (v == null) break;
            String strVal = SpdyHeaders.toString(v);
            SpdyCodecUtil.validateHeaderValue(strVal);
            this.addHeader0(h, i, lowerCaseName, strVal);
        }
    }

    void clearHeaders() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.head.before = this.head.after = this.head;
    }

    String getHeader(String name2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        int h = SpdyHeaders.hash(name2);
        int i = SpdyHeaders.index(h);
        HeaderEntry e2 = this.entries[i];
        while (e2 != null) {
            if (e2.hash == h && SpdyHeaders.eq(name2, e2.key)) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return null;
    }

    List<String> getHeaders(String name2) {
        if (name2 == null) {
            throw new NullPointerException("name");
        }
        LinkedList<String> values = new LinkedList<String>();
        int h = SpdyHeaders.hash(name2);
        int i = SpdyHeaders.index(h);
        HeaderEntry e2 = this.entries[i];
        while (e2 != null) {
            if (e2.hash == h && SpdyHeaders.eq(name2, e2.key)) {
                values.addFirst(e2.value);
            }
            e2 = e2.next;
        }
        return values;
    }

    List<Map.Entry<String, String>> getHeaders() {
        LinkedList<Map.Entry<String, String>> all2 = new LinkedList<Map.Entry<String, String>>();
        HeaderEntry e2 = this.head.after;
        while (e2 != this.head) {
            all2.add(e2);
            e2 = e2.after;
        }
        return all2;
    }

    boolean containsHeader(String name2) {
        return this.getHeader(name2) != null;
    }

    Set<String> getHeaderNames() {
        TreeSet<String> names = new TreeSet<String>();
        HeaderEntry e2 = this.head.after;
        while (e2 != this.head) {
            names.add(e2.key);
            e2 = e2.after;
        }
        return names;
    }

    private static String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HeaderEntry
    implements Map.Entry<String, String> {
        final int hash;
        final String key;
        String value;
        HeaderEntry next;
        HeaderEntry before;
        HeaderEntry after;

        HeaderEntry(int hash2, String key2, String value) {
            this.hash = hash2;
            this.key = key2;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(HeaderEntry e2) {
            this.after = e2;
            this.before = e2.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            SpdyCodecUtil.validateHeaderValue(value);
            String oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.key + '=' + this.value;
        }
    }

    public static final class Spdy2HttpNames {
        public static final String METHOD = "method";
        public static final String SCHEME = "scheme";
        public static final String STATUS = "status";
        public static final String URL = "url";
        public static final String VERSION = "version";

        private Spdy2HttpNames() {
        }
    }

    public static final class HttpNames {
        public static final String HOST = ":host";
        public static final String METHOD = ":method";
        public static final String PATH = ":path";
        public static final String SCHEME = ":scheme";
        public static final String STATUS = ":status";
        public static final String VERSION = ":version";

        private HttpNames() {
        }
    }
}

