/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.buffer;

import io.mantisrx.shaded.org.jboss.netty.buffer.AbstractChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBufferFactory;
import io.mantisrx.shaded.org.jboss.netty.buffer.WrappedChannelBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class ReadOnlyChannelBuffer
extends AbstractChannelBuffer
implements WrappedChannelBuffer {
    private final ChannelBuffer buffer;

    public ReadOnlyChannelBuffer(ChannelBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        this.buffer = buffer;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    private ReadOnlyChannelBuffer(ReadOnlyChannelBuffer buffer) {
        this.buffer = buffer.buffer;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    public ChannelBuffer unwrap() {
        return this.buffer;
    }

    public ChannelBufferFactory factory() {
        return this.buffer.factory();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new ReadOnlyBufferException();
    }

    public int arrayOffset() {
        throw new ReadOnlyBufferException();
    }

    public void discardReadBytes() {
        throw new ReadOnlyBufferException();
    }

    public void setByte(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    public void setBytes(int index2, ChannelBuffer src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    public void setBytes(int index2, byte[] src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    public void setBytes(int index2, ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    public void setShort(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    public void setMedium(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    public void setInt(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    public void setLong(int index2, long value) {
        throw new ReadOnlyBufferException();
    }

    public int setBytes(int index2, InputStream in, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        return this.buffer.getBytes(index2, out, length);
    }

    public void getBytes(int index2, OutputStream out, int length) throws IOException {
        this.buffer.getBytes(index2, out, length);
    }

    public void getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index2, dst, dstIndex, length);
    }

    public void getBytes(int index2, ChannelBuffer dst, int dstIndex, int length) {
        this.buffer.getBytes(index2, dst, dstIndex, length);
    }

    public void getBytes(int index2, ByteBuffer dst) {
        this.buffer.getBytes(index2, dst);
    }

    public ChannelBuffer duplicate() {
        return new ReadOnlyChannelBuffer(this);
    }

    public ChannelBuffer copy(int index2, int length) {
        return this.buffer.copy(index2, length);
    }

    public ChannelBuffer slice(int index2, int length) {
        return new ReadOnlyChannelBuffer(this.buffer.slice(index2, length));
    }

    public byte getByte(int index2) {
        return this.buffer.getByte(index2);
    }

    public short getShort(int index2) {
        return this.buffer.getShort(index2);
    }

    public int getUnsignedMedium(int index2) {
        return this.buffer.getUnsignedMedium(index2);
    }

    public int getInt(int index2) {
        return this.buffer.getInt(index2);
    }

    public long getLong(int index2) {
        return this.buffer.getLong(index2);
    }

    public ByteBuffer toByteBuffer(int index2, int length) {
        return this.buffer.toByteBuffer(index2, length).asReadOnlyBuffer();
    }

    public ByteBuffer[] toByteBuffers(int index2, int length) {
        ByteBuffer[] bufs = this.buffer.toByteBuffers(index2, length);
        for (int i = 0; i < bufs.length; ++i) {
            bufs[i] = bufs[i].asReadOnlyBuffer();
        }
        return bufs;
    }

    public int capacity() {
        return this.buffer.capacity();
    }
}

