/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.recipes.locks;

import io.mantisrx.shaded.org.apache.curator.framework.CuratorFramework;
import io.mantisrx.shaded.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.LockInternalsDriver;
import io.mantisrx.shaded.org.apache.curator.framework.recipes.locks.PredicateResults;
import io.mantisrx.shaded.org.apache.zookeeper.CreateMode;
import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardLockInternalsDriver
implements LockInternalsDriver {
    private static final Logger log = LoggerFactory.getLogger(StandardLockInternalsDriver.class);

    @Override
    public PredicateResults getsTheLock(CuratorFramework client, List<String> children2, String sequenceNodeName, int maxLeases) throws Exception {
        int ourIndex = children2.indexOf(sequenceNodeName);
        StandardLockInternalsDriver.validateOurIndex(sequenceNodeName, ourIndex);
        boolean getsTheLock = ourIndex < maxLeases;
        String pathToWatch = getsTheLock ? null : children2.get(ourIndex - maxLeases);
        return new PredicateResults(pathToWatch, getsTheLock);
    }

    @Override
    public String createsTheLock(CuratorFramework client, String path2, byte[] lockNodeBytes) throws Exception {
        String ourPath = lockNodeBytes != null ? (String)((ACLBackgroundPathAndBytesable)client.create().creatingParentContainersIfNeeded().withProtection().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(path2, lockNodeBytes) : (String)((ACLBackgroundPathAndBytesable)client.create().creatingParentContainersIfNeeded().withProtection().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(path2);
        return ourPath;
    }

    @Override
    public String fixForSorting(String str2, String lockName) {
        return StandardLockInternalsDriver.standardFixForSorting(str2, lockName);
    }

    public static String standardFixForSorting(String str2, String lockName) {
        int index2 = str2.lastIndexOf(lockName);
        if (index2 >= 0) {
            return (index2 += lockName.length()) <= str2.length() ? str2.substring(index2) : "";
        }
        return str2;
    }

    static void validateOurIndex(String sequenceNodeName, int ourIndex) throws KeeperException {
        if (ourIndex < 0) {
            throw new KeeperException.NoNodeException("Sequential path not found: " + sequenceNodeName);
        }
    }
}

