/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.graph;

import io.mantisrx.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.com.google.common.base.Function;
import io.mantisrx.shaded.com.google.common.base.Objects;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.collect.ImmutableSet;
import io.mantisrx.shaded.com.google.common.collect.Iterables;
import io.mantisrx.shaded.com.google.common.collect.Iterators;
import io.mantisrx.shaded.com.google.common.collect.Maps;
import io.mantisrx.shaded.com.google.common.graph.ElementTypesAreNonnullByDefault;
import io.mantisrx.shaded.com.google.common.graph.EndpointPair;
import io.mantisrx.shaded.com.google.common.graph.ForwardingGraph;
import io.mantisrx.shaded.com.google.common.graph.ForwardingNetwork;
import io.mantisrx.shaded.com.google.common.graph.ForwardingValueGraph;
import io.mantisrx.shaded.com.google.common.graph.Graph;
import io.mantisrx.shaded.com.google.common.graph.GraphBuilder;
import io.mantisrx.shaded.com.google.common.graph.IncidentEdgeSet;
import io.mantisrx.shaded.com.google.common.graph.MutableGraph;
import io.mantisrx.shaded.com.google.common.graph.MutableNetwork;
import io.mantisrx.shaded.com.google.common.graph.MutableValueGraph;
import io.mantisrx.shaded.com.google.common.graph.Network;
import io.mantisrx.shaded.com.google.common.graph.NetworkBuilder;
import io.mantisrx.shaded.com.google.common.graph.Traverser;
import io.mantisrx.shaded.com.google.common.graph.ValueGraph;
import io.mantisrx.shaded.com.google.common.graph.ValueGraphBuilder;
import io.mantisrx.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@Beta
public final class Graphs {
    private Graphs() {
    }

    public static <N> boolean hasCycle(Graph<N> graph2) {
        int numEdges = graph2.edges().size();
        if (numEdges == 0) {
            return false;
        }
        if (!graph2.isDirected() && numEdges >= graph2.nodes().size()) {
            return true;
        }
        HashMap<Object, NodeVisitState> visitedNodes = Maps.newHashMapWithExpectedSize(graph2.nodes().size());
        for (N node2 : graph2.nodes()) {
            if (!Graphs.subgraphHasCycle(graph2, visitedNodes, node2, null)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCycle(Network<?, ?> network) {
        if (!network.isDirected() && network.allowsParallelEdges() && network.edges().size() > network.asGraph().edges().size()) {
            return true;
        }
        return Graphs.hasCycle(network.asGraph());
    }

    private static <N> boolean subgraphHasCycle(Graph<N> graph2, Map<Object, NodeVisitState> visitedNodes, N node2, @CheckForNull N previousNode) {
        NodeVisitState state = visitedNodes.get(node2);
        if (state == NodeVisitState.COMPLETE) {
            return false;
        }
        if (state == NodeVisitState.PENDING) {
            return true;
        }
        visitedNodes.put(node2, NodeVisitState.PENDING);
        for (Object nextNode : graph2.successors((Object)node2)) {
            if (!Graphs.canTraverseWithoutReusingEdge(graph2, nextNode, previousNode) || !Graphs.subgraphHasCycle(graph2, visitedNodes, nextNode, node2)) continue;
            return true;
        }
        visitedNodes.put(node2, NodeVisitState.COMPLETE);
        return false;
    }

    private static boolean canTraverseWithoutReusingEdge(Graph<?> graph2, Object nextNode, @CheckForNull Object previousNode) {
        return graph2.isDirected() || !Objects.equal(previousNode, nextNode);
    }

    public static <N> Graph<N> transitiveClosure(Graph<N> graph2) {
        MutableGraph transitiveClosure = GraphBuilder.from(graph2).allowsSelfLoops(true).build();
        if (graph2.isDirected()) {
            for (N node2 : graph2.nodes()) {
                for (N reachableNode : Graphs.reachableNodes(graph2, node2)) {
                    transitiveClosure.putEdge(node2, reachableNode);
                }
            }
        } else {
            HashSet<N> visitedNodes = new HashSet<N>();
            for (N node3 : graph2.nodes()) {
                if (visitedNodes.contains(node3)) continue;
                Set<N> reachableNodes = Graphs.reachableNodes(graph2, node3);
                visitedNodes.addAll(reachableNodes);
                int pairwiseMatch = 1;
                for (N nodeU : reachableNodes) {
                    for (N nodeV : Iterables.limit(reachableNodes, pairwiseMatch++)) {
                        transitiveClosure.putEdge(nodeU, nodeV);
                    }
                }
            }
        }
        return transitiveClosure;
    }

    public static <N> Set<N> reachableNodes(Graph<N> graph2, N node2) {
        Preconditions.checkArgument(graph2.nodes().contains(node2), "Node %s is not an element of this graph.", node2);
        return ImmutableSet.copyOf(Traverser.forGraph(graph2).breadthFirst(node2));
    }

    public static <N> Graph<N> transpose(Graph<N> graph2) {
        if (!graph2.isDirected()) {
            return graph2;
        }
        if (graph2 instanceof TransposedGraph) {
            return ((TransposedGraph)graph2).graph;
        }
        return new TransposedGraph<N>(graph2);
    }

    public static <N, V> ValueGraph<N, V> transpose(ValueGraph<N, V> graph2) {
        if (!graph2.isDirected()) {
            return graph2;
        }
        if (graph2 instanceof TransposedValueGraph) {
            return ((TransposedValueGraph)graph2).graph;
        }
        return new TransposedValueGraph<N, V>(graph2);
    }

    public static <N, E> Network<N, E> transpose(Network<N, E> network) {
        if (!network.isDirected()) {
            return network;
        }
        if (network instanceof TransposedNetwork) {
            return ((TransposedNetwork)network).network;
        }
        return new TransposedNetwork<N, E>(network);
    }

    static <N> EndpointPair<N> transpose(EndpointPair<N> endpoints) {
        if (endpoints.isOrdered()) {
            return EndpointPair.ordered(endpoints.target(), endpoints.source());
        }
        return endpoints;
    }

    public static <N> MutableGraph<N> inducedSubgraph(Graph<N> graph2, Iterable<? extends N> nodes) {
        MutableGraph subgraph = nodes instanceof Collection ? GraphBuilder.from(graph2).expectedNodeCount(((Collection)nodes).size()).build() : GraphBuilder.from(graph2).build();
        for (Object node2 : nodes) {
            subgraph.addNode(node2);
        }
        for (Object node2 : subgraph.nodes()) {
            for (Object successorNode : graph2.successors(node2)) {
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.putEdge(node2, successorNode);
            }
        }
        return subgraph;
    }

    public static <N, V> MutableValueGraph<N, V> inducedSubgraph(ValueGraph<N, V> graph2, Iterable<? extends N> nodes) {
        MutableValueGraph subgraph = nodes instanceof Collection ? ValueGraphBuilder.from(graph2).expectedNodeCount(((Collection)nodes).size()).build() : ValueGraphBuilder.from(graph2).build();
        for (Object node2 : nodes) {
            subgraph.addNode(node2);
        }
        for (Object node2 : subgraph.nodes()) {
            for (Object successorNode : graph2.successors(node2)) {
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.putEdgeValue(node2, successorNode, java.util.Objects.requireNonNull(graph2.edgeValueOrDefault(node2, successorNode, null)));
            }
        }
        return subgraph;
    }

    public static <N, E> MutableNetwork<N, E> inducedSubgraph(Network<N, E> network, Iterable<? extends N> nodes) {
        MutableNetwork subgraph = nodes instanceof Collection ? NetworkBuilder.from(network).expectedNodeCount(((Collection)nodes).size()).build() : NetworkBuilder.from(network).build();
        for (Object node2 : nodes) {
            subgraph.addNode(node2);
        }
        for (Object node2 : subgraph.nodes()) {
            for (E edge : network.outEdges(node2)) {
                N successorNode = network.incidentNodes(edge).adjacentNode(node2);
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.addEdge(node2, successorNode, edge);
            }
        }
        return subgraph;
    }

    public static <N> MutableGraph<N> copyOf(Graph<N> graph2) {
        MutableGraph copy2 = GraphBuilder.from(graph2).expectedNodeCount(graph2.nodes().size()).build();
        for (N n : graph2.nodes()) {
            copy2.addNode(n);
        }
        for (EndpointPair endpointPair : graph2.edges()) {
            copy2.putEdge(endpointPair.nodeU(), endpointPair.nodeV());
        }
        return copy2;
    }

    public static <N, V> MutableValueGraph<N, V> copyOf(ValueGraph<N, V> graph2) {
        MutableValueGraph copy2 = ValueGraphBuilder.from(graph2).expectedNodeCount(graph2.nodes().size()).build();
        for (Object n : graph2.nodes()) {
            copy2.addNode(n);
        }
        for (EndpointPair endpointPair : graph2.edges()) {
            copy2.putEdgeValue(endpointPair.nodeU(), endpointPair.nodeV(), java.util.Objects.requireNonNull(graph2.edgeValueOrDefault(endpointPair.nodeU(), endpointPair.nodeV(), null)));
        }
        return copy2;
    }

    public static <N, E> MutableNetwork<N, E> copyOf(Network<N, E> network) {
        MutableNetwork copy2 = NetworkBuilder.from(network).expectedNodeCount(network.nodes().size()).expectedEdgeCount(network.edges().size()).build();
        for (N node2 : network.nodes()) {
            copy2.addNode(node2);
        }
        for (Object edge : network.edges()) {
            EndpointPair<N> endpointPair = network.incidentNodes(edge);
            copy2.addEdge(endpointPair.nodeU(), endpointPair.nodeV(), edge);
        }
        return copy2;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(int value) {
        Preconditions.checkArgument(value >= 0, "Not true that %s is non-negative.", value);
        return value;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(long value) {
        Preconditions.checkArgument(value >= 0L, "Not true that %s is non-negative.", value);
        return value;
    }

    @CanIgnoreReturnValue
    static int checkPositive(int value) {
        Preconditions.checkArgument(value > 0, "Not true that %s is positive.", value);
        return value;
    }

    @CanIgnoreReturnValue
    static long checkPositive(long value) {
        Preconditions.checkArgument(value > 0L, "Not true that %s is positive.", value);
        return value;
    }

    private static enum NodeVisitState {
        PENDING,
        COMPLETE;

    }

    private static class TransposedNetwork<N, E>
    extends ForwardingNetwork<N, E> {
        private final Network<N, E> network;

        TransposedNetwork(Network<N, E> network) {
            this.network = network;
        }

        @Override
        Network<N, E> delegate() {
            return this.network;
        }

        @Override
        public Set<N> predecessors(N node2) {
            return this.delegate().successors((Object)node2);
        }

        @Override
        public Set<N> successors(N node2) {
            return this.delegate().predecessors((Object)node2);
        }

        @Override
        public int inDegree(N node2) {
            return this.delegate().outDegree(node2);
        }

        @Override
        public int outDegree(N node2) {
            return this.delegate().inDegree(node2);
        }

        @Override
        public Set<E> inEdges(N node2) {
            return this.delegate().outEdges(node2);
        }

        @Override
        public Set<E> outEdges(N node2) {
            return this.delegate().inEdges(node2);
        }

        @Override
        public EndpointPair<N> incidentNodes(E edge) {
            EndpointPair<N> endpointPair = this.delegate().incidentNodes(edge);
            return EndpointPair.of(this.network, endpointPair.nodeV(), endpointPair.nodeU());
        }

        @Override
        public Set<E> edgesConnecting(N nodeU, N nodeV) {
            return this.delegate().edgesConnecting(nodeV, nodeU);
        }

        @Override
        public Set<E> edgesConnecting(EndpointPair<N> endpoints) {
            return this.delegate().edgesConnecting(Graphs.transpose(endpoints));
        }

        @Override
        public Optional<E> edgeConnecting(N nodeU, N nodeV) {
            return this.delegate().edgeConnecting(nodeV, nodeU);
        }

        @Override
        public Optional<E> edgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().edgeConnecting(Graphs.transpose(endpoints));
        }

        @Override
        @CheckForNull
        public E edgeConnectingOrNull(N nodeU, N nodeV) {
            return this.delegate().edgeConnectingOrNull(nodeV, nodeU);
        }

        @Override
        @CheckForNull
        public E edgeConnectingOrNull(EndpointPair<N> endpoints) {
            return this.delegate().edgeConnectingOrNull(Graphs.transpose(endpoints));
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpoints));
        }
    }

    private static class TransposedValueGraph<N, V>
    extends ForwardingValueGraph<N, V> {
        private final ValueGraph<N, V> graph;

        TransposedValueGraph(ValueGraph<N, V> graph2) {
            this.graph = graph2;
        }

        @Override
        ValueGraph<N, V> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N node2) {
            return this.delegate().successors((Object)node2);
        }

        @Override
        public Set<N> successors(N node2) {
            return this.delegate().predecessors((Object)node2);
        }

        @Override
        public int inDegree(N node2) {
            return this.delegate().outDegree(node2);
        }

        @Override
        public int outDegree(N node2) {
            return this.delegate().inDegree(node2);
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpoints));
        }

        @Override
        public Optional<V> edgeValue(N nodeU, N nodeV) {
            return this.delegate().edgeValue(nodeV, nodeU);
        }

        @Override
        public Optional<V> edgeValue(EndpointPair<N> endpoints) {
            return this.delegate().edgeValue(Graphs.transpose(endpoints));
        }

        @Override
        @CheckForNull
        public V edgeValueOrDefault(N nodeU, N nodeV, @CheckForNull V defaultValue) {
            return this.delegate().edgeValueOrDefault(nodeV, nodeU, defaultValue);
        }

        @Override
        @CheckForNull
        public V edgeValueOrDefault(EndpointPair<N> endpoints, @CheckForNull V defaultValue) {
            return this.delegate().edgeValueOrDefault(Graphs.transpose(endpoints), defaultValue);
        }
    }

    private static class TransposedGraph<N>
    extends ForwardingGraph<N> {
        private final Graph<N> graph;

        TransposedGraph(Graph<N> graph2) {
            this.graph = graph2;
        }

        @Override
        Graph<N> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N node2) {
            return this.delegate().successors((Object)node2);
        }

        @Override
        public Set<N> successors(N node2) {
            return this.delegate().predecessors((Object)node2);
        }

        @Override
        public Set<EndpointPair<N>> incidentEdges(N node2) {
            return new IncidentEdgeSet<N>(this, node2){

                @Override
                public Iterator<EndpointPair<N>> iterator() {
                    return Iterators.transform(this.delegate().incidentEdges(this.node).iterator(), new Function<EndpointPair<N>, EndpointPair<N>>(){

                        @Override
                        public EndpointPair<N> apply(EndpointPair<N> edge) {
                            return EndpointPair.of(this.delegate(), edge.nodeV(), edge.nodeU());
                        }
                    });
                }
            };
        }

        @Override
        public int inDegree(N node2) {
            return this.delegate().outDegree(node2);
        }

        @Override
        public int outDegree(N node2) {
            return this.delegate().inDegree(node2);
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }

        @Override
        public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
            return this.delegate().hasEdgeConnecting(Graphs.transpose(endpoints));
        }
    }
}

