/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.source.http;

import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.source.Index;
import io.mantisrx.runtime.source.Source;
import io.mantisrx.runtime.source.http.ClientResumePolicy;
import io.mantisrx.runtime.source.http.HttpClientFactory;
import io.mantisrx.runtime.source.http.HttpRequestFactory;
import io.mantisrx.runtime.source.http.HttpServerProvider;
import io.mantisrx.runtime.source.http.impl.HttpSourceImpl;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import rx.Observable;
import rx.Observer;

public class HttpSource<E, T>
implements Source<T> {
    private final HttpSourceImpl<ByteBuf, E, T> impl;

    private HttpSource(HttpSourceImpl<ByteBuf, E, T> impl) {
        this.impl = impl;
    }

    public static <E, T> Builder<E, T> builder(HttpSourceImpl.Builder<ByteBuf, E, T> builderImpl) {
        return new Builder(builderImpl);
    }

    public static <E> Builder<E, E> builder(HttpClientFactory<ByteBuf, E> clientFactory, HttpRequestFactory<ByteBuf> requestFactory) {
        HttpSourceImpl.Builder builderImpl = HttpSourceImpl.builder(clientFactory, requestFactory, HttpSourceImpl.identityConverter());
        return new Builder(builderImpl);
    }

    public static <E> Builder<E, E> builder(HttpClientFactory<ByteBuf, E> clientFactory, HttpRequestFactory<ByteBuf> requestFactory, ClientResumePolicy<ByteBuf, E> policy) {
        HttpSourceImpl.Builder builderImpl = HttpSourceImpl.builder(clientFactory, requestFactory, HttpSourceImpl.identityConverter(), policy);
        return new Builder(builderImpl);
    }

    @Override
    public Observable<Observable<T>> call(Context context, Index index2) {
        return this.impl.call(context, index2);
    }

    @Override
    public void close() throws IOException {
        this.impl.close();
    }

    public static class Builder<E, T> {
        private final HttpSourceImpl.Builder<ByteBuf, E, T> builderImpl;

        private Builder(HttpSourceImpl.Builder<ByteBuf, E, T> builderImpl) {
            this.builderImpl = builderImpl;
        }

        public Builder<E, T> withServerProvider(HttpServerProvider serverProvider) {
            this.builderImpl.withServerProvider(serverProvider);
            return this;
        }

        public Builder<E, T> withActivityObserver(Observer<HttpSourceImpl.HttpSourceEvent> observer) {
            this.builderImpl.withActivityObserver(observer);
            return this;
        }

        public Builder<E, T> resumeWith(ClientResumePolicy<ByteBuf, E> policy) {
            this.builderImpl.resumeWith(policy);
            return this;
        }

        public HttpSource<E, T> build() {
            return new HttpSource(this.builderImpl.build());
        }
    }
}

