/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Timer;
import io.mantisrx.common.metrics.spectator.CounterImpl;
import io.mantisrx.common.metrics.spectator.GaugeImpl;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.mantisrx.common.metrics.spectator.MetricId;
import io.mantisrx.common.metrics.spectator.SpectatorRegistryFactory;
import io.mantisrx.common.metrics.spectator.TimerImpl;
import io.mantisrx.shaded.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger logger = LoggerFactory.getLogger(Metrics.class);
    private final Builder builder;
    private MetricGroupId metricGroup;
    private Map<MetricId, Counter> counters = new HashMap<MetricId, Counter>();
    private Map<MetricId, Gauge> gauges = new HashMap<MetricId, Gauge>();
    private Map<MetricId, Timer> timers = new HashMap<MetricId, Timer>();

    public Metrics(Builder builder) {
        this.builder = builder;
        this.metricGroup = builder.metricGroup;
        if (builder.counterIds != null && builder.counterIds.size() > 0) {
            for (MetricId id : builder.counterIds) {
                logger.debug("creating spectator counter for {}", (Object)id);
                this.counters.put(id, new CounterImpl(id, builder.registry));
            }
        }
        if (builder.callbackGauges != null && builder.callbackGauges.size() > 0) {
            for (Gauge gauge : builder.callbackGauges) {
                this.gauges.put(gauge.id(), gauge);
            }
        }
        if (builder.gaugeIds != null && builder.gaugeIds.size() > 0) {
            for (MetricId gaugeId : builder.gaugeIds) {
                logger.debug("creating spectator gauge for {}", (Object)gaugeId);
                this.gauges.put(gaugeId, new GaugeImpl(gaugeId, builder.registry));
            }
        }
        if (builder.timerIds != null && builder.timerIds.size() > 0) {
            for (MetricId id : builder.timerIds) {
                logger.debug("creating spectator timer for {}", (Object)id);
                this.timers.put(id, new TimerImpl(id, builder.registry));
            }
        }
    }

    @Deprecated
    public String getMetricGroup() {
        return this.metricGroup.name();
    }

    public MetricGroupId getMetricGroupId() {
        return this.metricGroup;
    }

    public String toString() {
        return "Metrics{metricGroup=" + this.metricGroup + ", counters=" + this.counters.keySet() + ", gauges=" + this.gauges.keySet() + ", timers=" + this.timers.keySet() + '}';
    }

    public Counter getCounter(String metricName) {
        Counter counter = this.counters.get(new MetricId(this.metricGroup.name(), metricName, this.metricGroup.tags()));
        if (counter == null) {
            throw new RuntimeException("No counter registered for metricGroup: " + this.metricGroup + " with metricName: " + metricName);
        }
        return counter;
    }

    public Gauge getGauge(String metricName) {
        Gauge gauge = this.gauges.get(new MetricId(this.metricGroup.name(), metricName, this.metricGroup.tags()));
        if (gauge == null) {
            Gauge legacyGauge = this.gauges.get(new MetricId("legacyGaugeCallbackMetricGroup", metricName));
            if (legacyGauge == null) {
                throw new RuntimeException("No gauge registered for metricGroup: " + this.metricGroup + " with name: " + metricName);
            }
            return legacyGauge;
        }
        return gauge;
    }

    public Timer getTimer(String metricName) {
        Timer timer = this.timers.get(new MetricId(this.metricGroup.name(), metricName, this.metricGroup.tags()));
        if (timer == null) {
            throw new RuntimeException("No timer registered for metriGroup: " + this.metricGroup + " with name: " + metricName);
        }
        return timer;
    }

    public Counter getCounter(String metricName, Tag ... tags) {
        Counter counter = this.counters.get(new MetricId(this.metricGroup.name(), metricName, tags));
        if (counter == null) {
            throw new RuntimeException("No counter registered for metricGroup: " + this.metricGroup + " with metricName: " + metricName);
        }
        return counter;
    }

    public Gauge getGauge(String metricName, Tag ... tags) {
        Gauge gauge = this.gauges.get(new MetricId(this.metricGroup.name(), metricName, tags));
        if (gauge == null) {
            throw new RuntimeException("No gauge registered for metricGroup: " + this.metricGroup + " with metricName: " + metricName);
        }
        return gauge;
    }

    public Timer getTimer(String metricName, Tag ... tags) {
        Timer timer = this.timers.get(new MetricId(this.metricGroup.name(), metricName, tags));
        if (timer == null) {
            throw new RuntimeException("No timer registered for metricGroup: " + this.metricGroup + " with metricName: " + metricName);
        }
        return timer;
    }

    public Map<MetricId, Counter> counters() {
        return Collections.unmodifiableMap(this.counters);
    }

    public Map<MetricId, Gauge> gauges() {
        return Collections.unmodifiableMap(this.gauges);
    }

    public Map<MetricId, Timer> timers() {
        return Collections.unmodifiableMap(this.timers);
    }

    public static class Builder {
        private static Iterable<Tag> CommonTags = Collections.emptyList();
        private final Registry registry;
        private final Set<Gauge> callbackGauges = new HashSet<Gauge>();
        private final Set<MetricId> counterIds = new HashSet<MetricId>();
        private final Set<MetricId> gaugeIds = new HashSet<MetricId>();
        private final Set<MetricId> timerIds = new HashSet<MetricId>();
        private MetricGroupId metricGroup;

        public static void setCommonTags(Iterable<Tag> tags) {
            CommonTags = tags;
        }

        public Builder() {
            this(SpectatorRegistryFactory.getRegistry());
        }

        public Builder(Registry registry) {
            this.registry = registry;
        }

        public Builder name(String metricGroup) {
            this.metricGroup = new MetricGroupId(metricGroup, CommonTags);
            return this;
        }

        public Builder id(MetricGroupId metricGroup) {
            this.metricGroup = new MetricGroupId(metricGroup.name(), ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(metricGroup.tags())).addAll(CommonTags)).build());
            return this;
        }

        public Builder id(String metricGroup, Collection<Tag> groupTags) {
            this.metricGroup = new MetricGroupId(metricGroup, ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(groupTags)).addAll(CommonTags)).build());
            return this;
        }

        public Builder id(String metricGroup, Tag ... groupTags) {
            this.metricGroup = new MetricGroupId(metricGroup, ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(groupTags)).addAll(CommonTags)).build());
            return this;
        }

        public Builder addCounter(String metricName) {
            Preconditions.checkNotNull((Object)this.metricGroup, (String)"set metric group id with id(String, Tag...) before adding Counter");
            this.counterIds.add(new MetricId(this.metricGroup.name(), metricName, this.metricGroup.tags()));
            return this;
        }

        @Deprecated
        public Builder addCounter(String metricName, Iterable<Tag> overrideGroupTags) {
            Preconditions.checkNotNull((Object)this.metricGroup, (String)"set metric group id with id(String, Tag...) before adding Counter");
            this.counterIds.add(new MetricId(this.metricGroup.name(), metricName, overrideGroupTags));
            return this;
        }

        @Deprecated
        public Builder addCounter(String metricName, Tag ... overrideGroupTags) {
            Preconditions.checkNotNull((Object)this.metricGroup, (String)"set metric group id with id(String, Tag...) before adding Counter");
            this.counterIds.add(new MetricId(this.metricGroup.name(), metricName, overrideGroupTags));
            return this;
        }

        public Builder addGauge(String metricName) {
            Preconditions.checkNotNull((Object)this.metricGroup, (String)"set metric group id with id(String, Tag...) before adding Gauge");
            this.gaugeIds.add(new MetricId(this.metricGroup.name(), metricName, this.metricGroup.tags()));
            return this;
        }

        @Deprecated
        public Builder addGauge(String metricName, Iterable<Tag> overrideGroupTags) {
            Preconditions.checkNotNull((Object)this.metricGroup, (String)"set metric group id with id(String, Tag...) before adding Gauge");
            this.gaugeIds.add(new MetricId(this.metricGroup.name(), metricName, overrideGroupTags));
            return this;
        }

        @Deprecated
        public Builder addGauge(String metricName, Tag ... overrideGroupTags) {
            Preconditions.checkNotNull((Object)this.metricGroup, (String)"set metric group id with id(String, Tag...) before adding Gauge");
            this.gaugeIds.add(new MetricId(this.metricGroup.name(), metricName, overrideGroupTags));
            return this;
        }

        public Builder addGauge(Gauge callbackGauge) {
            Preconditions.checkNotNull((Object)this.metricGroup, (String)"set metric group id with id(String, Tag...) before adding Gauge");
            this.callbackGauges.add(callbackGauge);
            return this;
        }

        public Builder addTimer(String metricName) {
            Preconditions.checkNotNull((Object)this.metricGroup, (String)"set metric group id with id(String, Tag...) before adding Timer");
            this.timerIds.add(new MetricId(this.metricGroup.name(), metricName, this.metricGroup.tags()));
            return this;
        }

        public Metrics build() {
            if (this.metricGroup == null || this.metricGroup.name().length() == 0) {
                throw new IllegalArgumentException("metricGroup must be specified for metrics");
            }
            return new Metrics(this);
        }
    }
}

