/*
 * Decompiled with CFR 0.152.
 */
package mantis.io.reactivex.netty.protocol.http.sse;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import mantis.io.reactivex.netty.protocol.http.client.ClientRequestResponseConverter;
import mantis.io.reactivex.netty.protocol.http.sse.ServerSentEventDecoder;

@ChannelHandler.Sharable
public class SseChannelHandler
extends SimpleChannelInboundHandler<Object> {
    public static final String NAME = "sse-inbound-handler";
    public static final String SSE_DECODER_HANDLER_NAME = "rx-sse-decoder";
    public static final String SSE_DECODER_POST_INBOUND_HANDLER = "rx-sse-decoder-post-inbound";

    public SseChannelHandler() {
        super(false);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            ctx.channel().attr(ClientRequestResponseConverter.DISCARD_CONNECTION).set(true);
            ChannelPipeline pipeline = ctx.channel().pipeline();
            pipeline.addAfter(NAME, SSE_DECODER_HANDLER_NAME, new ServerSentEventDecoder());
            ctx.fireChannelRead(msg);
        } else if (msg instanceof LastHttpContent) {
            LastHttpContent lastHttpContent = (LastHttpContent)msg;
            lastHttpContent.content().retain();
            if (lastHttpContent.content().isReadable()) {
                ctx.fireChannelRead(lastHttpContent.content());
            }
            ctx.fireChannelRead(msg);
        } else if (msg instanceof HttpContent) {
            ctx.fireChannelRead(((HttpContent)msg).content());
        } else {
            ctx.fireChannelRead(msg);
        }
    }
}

