/*
 * Decompiled with CFR 0.152.
 */
package io.reactivx.mantis.operators;

import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.subscriptions.Subscriptions;

public class DropOperator<T>
implements Observable.Operator<T, T> {
    public static final String METRIC_GROUP = "DropOperator";
    private static final Logger logger = LoggerFactory.getLogger(DropOperator.class);
    private final Counter next;
    private final Counter error;
    private final Counter complete;
    private final Counter dropped;
    MetricGroupId metricGroupId;

    public DropOperator(Metrics m) {
        this.next = m.getCounter("" + (Object)((Object)Counters.onNext));
        this.error = m.getCounter("" + (Object)((Object)Counters.onError));
        this.complete = m.getCounter("" + (Object)((Object)Counters.onComplete));
        this.dropped = m.getCounter("" + (Object)((Object)Counters.dropped));
    }

    public DropOperator(MetricGroupId groupId) {
        this.metricGroupId = groupId;
        Metrics m = new Metrics.Builder().id(this.metricGroupId).addCounter("" + (Object)((Object)Counters.onNext)).addCounter("" + (Object)((Object)Counters.onError)).addCounter("" + (Object)((Object)Counters.onComplete)).addCounter("" + (Object)((Object)Counters.dropped)).build();
        m = MetricsRegistry.getInstance().registerAndGet(m);
        this.next = m.getCounter("" + (Object)((Object)Counters.onNext));
        this.error = m.getCounter("" + (Object)((Object)Counters.onError));
        this.complete = m.getCounter("" + (Object)((Object)Counters.onComplete));
        this.dropped = m.getCounter("" + (Object)((Object)Counters.dropped));
    }

    public DropOperator(String name2) {
        this(new MetricGroupId("DropOperator_" + name2));
    }

    public DropOperator(String name2, Tag ... tags) {
        this(new MetricGroupId("DropOperator_" + name2, tags));
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> o) {
        final AtomicLong requested = new AtomicLong();
        o.add(Subscriptions.create(() -> {}));
        o.setProducer(new Producer(){

            @Override
            public void request(long n) {
                if (requested.get() == Long.MAX_VALUE) {
                    logger.warn("current requested is int max do not increment");
                } else {
                    requested.getAndAdd(n);
                }
            }
        });
        return new Subscriber<T>(o){

            @Override
            public void onCompleted() {
                DropOperator.this.complete.increment();
                o.onCompleted();
            }

            @Override
            public void onError(Throwable e2) {
                DropOperator.this.error.increment();
                logger.error("onError() occured in DropOperator for groupId: {}", (Object)DropOperator.this.metricGroupId.id(), (Object)e2);
                o.onError(e2);
            }

            @Override
            public void onNext(T t) {
                if (requested.get() > 0L) {
                    requested.decrementAndGet();
                    o.onNext(t);
                    DropOperator.this.next.increment();
                } else {
                    DropOperator.this.dropped.increment();
                }
            }

            @Override
            public void setProducer(Producer p) {
                p.request(Long.MAX_VALUE);
            }
        };
    }

    public static enum Gauges {
        subscribe,
        requested;

    }

    public static enum Counters {
        onNext,
        onError,
        onComplete,
        dropped;

    }
}

