/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.protobuf;

import io.mantisrx.shaded.com.google.protobuf.CodedInputStream;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.frame.FrameDecoder;

public class ProtobufVarint32FrameDecoder
extends FrameDecoder {
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        buffer.markReaderIndex();
        byte[] buf = new byte[5];
        for (int i = 0; i < buf.length; ++i) {
            if (!buffer.readable()) {
                buffer.resetReaderIndex();
                return null;
            }
            buf[i] = buffer.readByte();
            if (buf[i] < 0) continue;
            int length = CodedInputStream.newInstance((byte[])buf, (int)0, (int)(i + 1)).readRawVarint32();
            if (length < 0) {
                throw new CorruptedFrameException("negative length: " + length);
            }
            if (buffer.readableBytes() < length) {
                buffer.resetReaderIndex();
                return null;
            }
            return buffer.readBytes(length);
        }
        throw new CorruptedFrameException("length wider than 32-bit");
    }
}

