/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.http.multipart;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffers;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpConstants;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.multipart.AbstractHttpData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public abstract class AbstractMemoryHttpData
extends AbstractHttpData {
    private ChannelBuffer channelBuffer;
    private int chunkPosition;
    protected boolean isRenamed;

    protected AbstractMemoryHttpData(String name2, Charset charset, long size) {
        super(name2, charset, size);
    }

    public void setContent(ChannelBuffer buffer) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        long localsize = buffer.readableBytes();
        if (this.definedSize > 0L && this.definedSize < localsize) {
            throw new IOException("Out of size: " + localsize + " > " + this.definedSize);
        }
        this.channelBuffer = buffer;
        this.size = localsize;
        this.completed = true;
    }

    public void setContent(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        byte[] bytes2 = new byte[16384];
        int read2 = inputStream.read(bytes2);
        int written = 0;
        while (read2 > 0) {
            buffer.writeBytes(bytes2, 0, read2);
            written += read2;
            read2 = inputStream.read(bytes2);
        }
        this.size = written;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        this.channelBuffer = buffer;
        this.completed = true;
    }

    public void addContent(ChannelBuffer buffer, boolean last2) throws IOException {
        if (buffer != null) {
            long localsize = buffer.readableBytes();
            if (this.definedSize > 0L && this.definedSize < this.size + localsize) {
                throw new IOException("Out of size: " + (this.size + localsize) + " > " + this.definedSize);
            }
            this.size += localsize;
            this.channelBuffer = this.channelBuffer == null ? buffer : ChannelBuffers.wrappedBuffer(this.channelBuffer, buffer);
        }
        if (last2) {
            this.completed = true;
        } else if (buffer == null) {
            throw new NullPointerException("buffer");
        }
    }

    public void setContent(File file2) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("file");
        }
        long newsize = file2.length();
        if (newsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        FileInputStream inputStream = new FileInputStream(file2);
        FileChannel fileChannel = inputStream.getChannel();
        byte[] array2 = new byte[(int)newsize];
        ByteBuffer byteBuffer = ByteBuffer.wrap(array2);
        int read2 = 0;
        while ((long)read2 < newsize) {
            read2 += fileChannel.read(byteBuffer);
        }
        fileChannel.close();
        inputStream.close();
        byteBuffer.flip();
        this.channelBuffer = ChannelBuffers.wrappedBuffer(byteBuffer);
        this.size = newsize;
        this.completed = true;
    }

    public void delete() {
    }

    public byte[] get() {
        if (this.channelBuffer == null) {
            return new byte[0];
        }
        byte[] array2 = new byte[this.channelBuffer.readableBytes()];
        this.channelBuffer.getBytes(this.channelBuffer.readerIndex(), array2);
        return array2;
    }

    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    public String getString(Charset encoding2) {
        if (this.channelBuffer == null) {
            return "";
        }
        if (encoding2 == null) {
            encoding2 = HttpConstants.DEFAULT_CHARSET;
        }
        return this.channelBuffer.toString(encoding2);
    }

    public ChannelBuffer getChannelBuffer() {
        return this.channelBuffer;
    }

    public ChannelBuffer getChunk(int length) throws IOException {
        if (this.channelBuffer == null || length == 0 || this.channelBuffer.readableBytes() == 0) {
            this.chunkPosition = 0;
            return ChannelBuffers.EMPTY_BUFFER;
        }
        int sizeLeft = this.channelBuffer.readableBytes() - this.chunkPosition;
        if (sizeLeft == 0) {
            this.chunkPosition = 0;
            return ChannelBuffers.EMPTY_BUFFER;
        }
        int sliceLength = length;
        if (sizeLeft < length) {
            sliceLength = sizeLeft;
        }
        ChannelBuffer chunk2 = this.channelBuffer.slice(this.chunkPosition, sliceLength);
        this.chunkPosition += sliceLength;
        return chunk2;
    }

    public boolean isInMemory() {
        return true;
    }

    public boolean renameTo(File dest) throws IOException {
        int written;
        if (dest == null) {
            throw new NullPointerException("dest");
        }
        if (this.channelBuffer == null) {
            dest.createNewFile();
            this.isRenamed = true;
            return true;
        }
        int length = this.channelBuffer.readableBytes();
        FileOutputStream outputStream = new FileOutputStream(dest);
        FileChannel fileChannel = outputStream.getChannel();
        ByteBuffer byteBuffer = this.channelBuffer.toByteBuffer();
        for (written = 0; written < length; written += fileChannel.write(byteBuffer)) {
        }
        fileChannel.force(false);
        fileChannel.close();
        outputStream.close();
        this.isRenamed = true;
        return written == length;
    }

    public File getFile() throws IOException {
        throw new IOException("Not represented by a file");
    }
}

