/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.channel.socket.nio;

import io.mantisrx.shaded.org.jboss.netty.logging.InternalLogger;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import io.mantisrx.shaded.org.jboss.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;

final class SelectorUtil {
    private static final InternalLogger logger;
    static final int DEFAULT_IO_THREADS;
    static final long DEFAULT_SELECT_TIMEOUT = 500L;
    static final long SELECT_TIMEOUT;
    static final long SELECT_TIMEOUT_NANOS;
    static final boolean EPOLL_BUG_WORKAROUND;

    static Selector open() throws IOException {
        return Selector.open();
    }

    static int select(Selector selector) throws IOException {
        try {
            return selector.select(SELECT_TIMEOUT);
        }
        catch (CancelledKeyException e2) {
            if (logger.isDebugEnabled()) {
                logger.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector - JDK bug?", e2);
            }
            return -1;
        }
    }

    private SelectorUtil() {
    }

    static {
        block4: {
            logger = InternalLoggerFactory.getInstance(SelectorUtil.class);
            DEFAULT_IO_THREADS = Runtime.getRuntime().availableProcessors() * 2;
            SELECT_TIMEOUT = SystemPropertyUtil.getLong("io.mantisrx.shaded.org.jboss.netty.selectTimeout", 500L);
            SELECT_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(SELECT_TIMEOUT);
            EPOLL_BUG_WORKAROUND = SystemPropertyUtil.getBoolean("io.mantisrx.shaded.org.jboss.netty.epollBugWorkaround", false);
            String key2 = "sun.nio.ch.bugLevel";
            try {
                String buglevel = System.getProperty(key2);
                if (buglevel == null) {
                    System.setProperty(key2, "");
                }
            }
            catch (SecurityException e2) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Unable to get/set System Property '" + key2 + '\'', e2);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Using select timeout of " + SELECT_TIMEOUT);
            logger.debug("Epoll-bug workaround enabled = " + EPOLL_BUG_WORKAROUND);
        }
    }
}

