/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.com.google.common.math;

import io.mantisrx.shaded.com.google.common.annotations.Beta;
import io.mantisrx.shaded.com.google.common.annotations.GwtIncompatible;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.math.ElementTypesAreNonnullByDefault;
import io.mantisrx.shaded.com.google.common.math.LongMath;
import io.mantisrx.shaded.com.google.common.primitives.Doubles;
import io.mantisrx.shaded.com.google.common.primitives.Ints;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class Quantiles {
    public static ScaleAndIndex median() {
        return Quantiles.scale(2).index(1);
    }

    public static Scale quartiles() {
        return Quantiles.scale(4);
    }

    public static Scale percentiles() {
        return Quantiles.scale(100);
    }

    public static Scale scale(int scale) {
        return new Scale(scale);
    }

    private static boolean containsNaN(double ... dataset) {
        for (double value : dataset) {
            if (!Double.isNaN(value)) continue;
            return true;
        }
        return false;
    }

    private static double interpolate(double lower, double upper, double remainder, double scale) {
        if (lower == Double.NEGATIVE_INFINITY) {
            if (upper == Double.POSITIVE_INFINITY) {
                return Double.NaN;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (upper == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return lower + (upper - lower) * remainder / scale;
    }

    private static void checkIndex(int index2, int scale) {
        if (index2 < 0 || index2 > scale) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Quantile indexes must be between 0 and the scale, which is ").append(scale).toString());
        }
    }

    private static double[] longsToDoubles(long[] longs2) {
        int len = longs2.length;
        double[] doubles2 = new double[len];
        for (int i = 0; i < len; ++i) {
            doubles2[i] = longs2[i];
        }
        return doubles2;
    }

    private static double[] intsToDoubles(int[] ints2) {
        int len = ints2.length;
        double[] doubles2 = new double[len];
        for (int i = 0; i < len; ++i) {
            doubles2[i] = ints2[i];
        }
        return doubles2;
    }

    private static void selectInPlace(int required2, double[] array2, int from, int to) {
        if (required2 == from) {
            int min2 = from;
            for (int index2 = from + 1; index2 <= to; ++index2) {
                if (!(array2[min2] > array2[index2])) continue;
                min2 = index2;
            }
            if (min2 != from) {
                Quantiles.swap(array2, min2, from);
            }
            return;
        }
        while (to > from) {
            int partitionPoint = Quantiles.partition(array2, from, to);
            if (partitionPoint >= required2) {
                to = partitionPoint - 1;
            }
            if (partitionPoint > required2) continue;
            from = partitionPoint + 1;
        }
    }

    private static int partition(double[] array2, int from, int to) {
        Quantiles.movePivotToStartOfSlice(array2, from, to);
        double pivot = array2[from];
        int partitionPoint = to;
        for (int i = to; i > from; --i) {
            if (!(array2[i] > pivot)) continue;
            Quantiles.swap(array2, partitionPoint, i);
            --partitionPoint;
        }
        Quantiles.swap(array2, from, partitionPoint);
        return partitionPoint;
    }

    private static void movePivotToStartOfSlice(double[] array2, int from, int to) {
        boolean toLessThanFrom;
        int mid = from + to >>> 1;
        boolean toLessThanMid = array2[to] < array2[mid];
        boolean midLessThanFrom = array2[mid] < array2[from];
        boolean bl = toLessThanFrom = array2[to] < array2[from];
        if (toLessThanMid == midLessThanFrom) {
            Quantiles.swap(array2, mid, from);
        } else if (toLessThanMid != toLessThanFrom) {
            Quantiles.swap(array2, from, to);
        }
    }

    private static void selectAllInPlace(int[] allRequired, int requiredFrom, int requiredTo, double[] array2, int from, int to) {
        int requiredAbove;
        int requiredBelow;
        int requiredChosen = Quantiles.chooseNextSelection(allRequired, requiredFrom, requiredTo, from, to);
        int required2 = allRequired[requiredChosen];
        Quantiles.selectInPlace(required2, array2, from, to);
        for (requiredBelow = requiredChosen - 1; requiredBelow >= requiredFrom && allRequired[requiredBelow] == required2; --requiredBelow) {
        }
        if (requiredBelow >= requiredFrom) {
            Quantiles.selectAllInPlace(allRequired, requiredFrom, requiredBelow, array2, from, required2 - 1);
        }
        for (requiredAbove = requiredChosen + 1; requiredAbove <= requiredTo && allRequired[requiredAbove] == required2; ++requiredAbove) {
        }
        if (requiredAbove <= requiredTo) {
            Quantiles.selectAllInPlace(allRequired, requiredAbove, requiredTo, array2, required2 + 1, to);
        }
    }

    private static int chooseNextSelection(int[] allRequired, int requiredFrom, int requiredTo, int from, int to) {
        if (requiredFrom == requiredTo) {
            return requiredFrom;
        }
        int centerFloor = from + to >>> 1;
        int low = requiredFrom;
        int high = requiredTo;
        while (high > low + 1) {
            int mid = low + high >>> 1;
            if (allRequired[mid] > centerFloor) {
                high = mid;
                continue;
            }
            if (allRequired[mid] < centerFloor) {
                low = mid;
                continue;
            }
            return mid;
        }
        if (from + to - allRequired[low] - allRequired[high] > 0) {
            return high;
        }
        return low;
    }

    private static void swap(double[] array2, int i, int j) {
        double temp = array2[i];
        array2[i] = array2[j];
        array2[j] = temp;
    }

    public static final class ScaleAndIndexes {
        private final int scale;
        private final int[] indexes;

        private ScaleAndIndexes(int scale, int[] indexes) {
            for (int index2 : indexes) {
                Quantiles.checkIndex(index2, scale);
            }
            Preconditions.checkArgument(indexes.length > 0, "Indexes must be a non empty array");
            this.scale = scale;
            this.indexes = indexes;
        }

        public Map<Integer, Double> compute(Collection<? extends Number> dataset) {
            return this.computeInPlace(Doubles.toArray(dataset));
        }

        public Map<Integer, Double> compute(double ... dataset) {
            return this.computeInPlace((double[])dataset.clone());
        }

        public Map<Integer, Double> compute(long ... dataset) {
            return this.computeInPlace(Quantiles.longsToDoubles(dataset));
        }

        public Map<Integer, Double> compute(int ... dataset) {
            return this.computeInPlace(Quantiles.intsToDoubles(dataset));
        }

        public Map<Integer, Double> computeInPlace(double ... dataset) {
            Preconditions.checkArgument(dataset.length > 0, "Cannot calculate quantiles of an empty dataset");
            if (Quantiles.containsNaN(dataset)) {
                LinkedHashMap<Integer, Double> nanMap = new LinkedHashMap<Integer, Double>();
                for (int index2 : this.indexes) {
                    nanMap.put(index2, Double.NaN);
                }
                return Collections.unmodifiableMap(nanMap);
            }
            int[] quotients = new int[this.indexes.length];
            int[] remainders2 = new int[this.indexes.length];
            int[] requiredSelections = new int[this.indexes.length * 2];
            int requiredSelectionsCount = 0;
            for (int i = 0; i < this.indexes.length; ++i) {
                long numerator2 = (long)this.indexes[i] * (long)(dataset.length - 1);
                int quotient = (int)LongMath.divide(numerator2, this.scale, RoundingMode.DOWN);
                int remainder = (int)(numerator2 - (long)quotient * (long)this.scale);
                quotients[i] = quotient;
                remainders2[i] = remainder;
                requiredSelections[requiredSelectionsCount] = quotient;
                ++requiredSelectionsCount;
                if (remainder == 0) continue;
                requiredSelections[requiredSelectionsCount] = quotient + 1;
                ++requiredSelectionsCount;
            }
            Arrays.sort(requiredSelections, 0, requiredSelectionsCount);
            Quantiles.selectAllInPlace(requiredSelections, 0, requiredSelectionsCount - 1, dataset, 0, dataset.length - 1);
            LinkedHashMap<Integer, Double> ret = new LinkedHashMap<Integer, Double>();
            for (int i = 0; i < this.indexes.length; ++i) {
                int quotient = quotients[i];
                int remainder = remainders2[i];
                if (remainder == 0) {
                    ret.put(this.indexes[i], dataset[quotient]);
                    continue;
                }
                ret.put(this.indexes[i], Quantiles.interpolate(dataset[quotient], dataset[quotient + 1], remainder, this.scale));
            }
            return Collections.unmodifiableMap(ret);
        }
    }

    public static final class ScaleAndIndex {
        private final int scale;
        private final int index;

        private ScaleAndIndex(int scale, int index2) {
            Quantiles.checkIndex(index2, scale);
            this.scale = scale;
            this.index = index2;
        }

        public double compute(Collection<? extends Number> dataset) {
            return this.computeInPlace(Doubles.toArray(dataset));
        }

        public double compute(double ... dataset) {
            return this.computeInPlace((double[])dataset.clone());
        }

        public double compute(long ... dataset) {
            return this.computeInPlace(Quantiles.longsToDoubles(dataset));
        }

        public double compute(int ... dataset) {
            return this.computeInPlace(Quantiles.intsToDoubles(dataset));
        }

        public double computeInPlace(double ... dataset) {
            Preconditions.checkArgument(dataset.length > 0, "Cannot calculate quantiles of an empty dataset");
            if (Quantiles.containsNaN(dataset)) {
                return Double.NaN;
            }
            long numerator2 = (long)this.index * (long)(dataset.length - 1);
            int quotient = (int)LongMath.divide(numerator2, this.scale, RoundingMode.DOWN);
            int remainder = (int)(numerator2 - (long)quotient * (long)this.scale);
            Quantiles.selectInPlace(quotient, dataset, 0, dataset.length - 1);
            if (remainder == 0) {
                return dataset[quotient];
            }
            Quantiles.selectInPlace(quotient + 1, dataset, quotient + 1, dataset.length - 1);
            return Quantiles.interpolate(dataset[quotient], dataset[quotient + 1], remainder, this.scale);
        }
    }

    public static final class Scale {
        private final int scale;

        private Scale(int scale) {
            Preconditions.checkArgument(scale > 0, "Quantile scale must be positive");
            this.scale = scale;
        }

        public ScaleAndIndex index(int index2) {
            return new ScaleAndIndex(this.scale, index2);
        }

        public ScaleAndIndexes indexes(int ... indexes) {
            return new ScaleAndIndexes(this.scale, (int[])indexes.clone());
        }

        public ScaleAndIndexes indexes(Collection<Integer> indexes) {
            return new ScaleAndIndexes(this.scale, Ints.toArray(indexes));
        }
    }
}

