/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.common.properties.DefaultMantisPropertiesLoader;
import io.mantisrx.common.properties.MantisPropertiesLoader;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistry {
    private static Logger logger = LoggerFactory.getLogger(ServiceRegistry.class);
    private final AtomicReference<MantisPropertiesLoader> registryRef = new AtomicReference<Object>(null);
    public static ServiceRegistry INSTANCE = new ServiceRegistry();

    private ServiceRegistry() {
    }

    public void setMantisPropertiesService(MantisPropertiesLoader service) {
        logger.info(String.format("Setting Mantis Properties Service to %s", service), new Exception());
        if (!this.registryRef.compareAndSet(null, service)) {
            logger.error("MantisPropertiesService already set to {}", (Object)this.registryRef.get());
        }
    }

    public MantisPropertiesLoader getPropertiesService() {
        if (this.registryRef.get() == null) {
            this.setMantisPropertiesService(ServiceRegistry.loadMantisPropertiesLoader());
        }
        return this.registryRef.get();
    }

    private static MantisPropertiesLoader loadMantisPropertiesLoader() {
        MantisPropertiesLoader mpl = new DefaultMantisPropertiesLoader(new Properties());
        try {
            mpl = (MantisPropertiesLoader)Class.forName("com.netflix.mantis.common.properties.MantisFastPropertiesLoader").getConstructor(Properties.class).newInstance(new Properties());
        }
        catch (Exception e2) {
            logger.warn("Could not load MantisFastPropertiesLoader");
        }
        return mpl;
    }
}

