/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.codec;

import io.mantisrx.common.codec.Codec;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class Codecs {
    public static Codec<Integer> integer() {
        return new Codec<Integer>(){

            @Override
            public Integer decode(byte[] bytes2) {
                return ByteBuffer.wrap(bytes2).getInt();
            }

            @Override
            public byte[] encode(Integer value) {
                return ByteBuffer.allocate(4).putInt(value).array();
            }
        };
    }

    public static Codec<Long> longNumber() {
        return new Codec<Long>(){

            @Override
            public Long decode(byte[] bytes2) {
                return ByteBuffer.wrap(bytes2).getLong();
            }

            @Override
            public byte[] encode(Long value) {
                return ByteBuffer.allocate(8).putLong(value).array();
            }
        };
    }

    private static Codec<String> stringWithEncoding(String encoding2) {
        final Charset charset = Charset.forName(encoding2);
        return new Codec<String>(){

            @Override
            public String decode(byte[] bytes2) {
                return new String(bytes2, charset);
            }

            @Override
            public byte[] encode(String value) {
                return value.getBytes(charset);
            }
        };
    }

    public static Codec<String> stringAscii() {
        final Charset charset = Charset.forName("US-ASCII");
        return new Codec<String>(){

            @Override
            public String decode(byte[] bytes2) {
                return new String(bytes2, charset);
            }

            @Override
            public byte[] encode(String value) {
                byte[] bytes2 = new byte[value.length()];
                for (int i = 0; i < value.length(); ++i) {
                    bytes2[i] = (byte)value.charAt(i);
                }
                return bytes2;
            }
        };
    }

    public static Codec<String> stringUtf8() {
        return Codecs.stringWithEncoding("UTF-8");
    }

    public static Codec<String> string() {
        return Codecs.stringUtf8();
    }

    public static Codec<byte[]> bytearray() {
        return new Codec<byte[]>(){

            @Override
            public byte[] decode(byte[] bytes2) {
                return bytes2;
            }

            @Override
            public byte[] encode(byte[] value) {
                return value;
            }
        };
    }

    public static <T extends Serializable> Codec<T> javaSerializer() {
        return new Codec<T>(){

            @Override
            public T decode(byte[] bytes2) {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes2);
                try {
                    ObjectInputStream in = new ObjectInputStream(bis);
                    return (Serializable)in.readObject();
                }
                catch (IOException | ClassNotFoundException e2) {
                    throw new RuntimeException(e2);
                }
            }

            /*
             * Exception decompiling
             */
            @Override
            public byte[] encode(T value) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }
}

