/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import org.jctools.queues.BaseSpscLinkedArrayQueue;
import org.jctools.queues.CircularArrayOffsetCalculator;
import org.jctools.queues.SpscArrayQueue;
import org.jctools.util.Pow2;
import org.jctools.util.UnsafeRefArrayAccess;

public class SpscGrowableArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    public SpscGrowableArrayQueue(int capacity) {
        this(Pow2.roundToPowerOfTwo(Math.max(capacity, 32) / 2), Math.max(capacity, 32));
    }

    public SpscGrowableArrayQueue(int initialCapacity, int capacity) {
        int p2initialCapacity = Pow2.roundToPowerOfTwo(Math.max(initialCapacity, 32) / 2);
        int p2capacity = Pow2.roundToPowerOfTwo(Math.max(capacity, 32));
        if (p2initialCapacity >= p2capacity) {
            throw new IllegalArgumentException("Initial capacity(" + initialCapacity + ") rounded up to a power of 2 cannot exceed maximum capacity (" + capacity + ")rounded up to a power of 2");
        }
        long mask = p2initialCapacity - 1;
        E[] buffer = CircularArrayOffsetCalculator.allocate(p2initialCapacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.adjustLookAheadStep(p2initialCapacity);
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.maxQueueCapacity = p2capacity;
        this.producerLimit = mask - 1L;
        this.soProducerIndex(0L);
    }

    @Override
    protected boolean offerColdPath(E[] buffer, long mask, E e2, long index2, long offset) {
        int maxCapacity;
        int lookAheadStep = this.producerLookAheadStep;
        if (lookAheadStep > 0) {
            long lookAheadElementOffset = CircularArrayOffsetCalculator.calcElementOffset(index2 + (long)lookAheadStep, mask);
            if (null == UnsafeRefArrayAccess.lvElement(buffer, lookAheadElementOffset)) {
                this.producerLimit = index2 + (long)lookAheadStep - 1L;
                this.writeToQueue(buffer, e2, index2, offset);
                return true;
            }
            int maxCapacity2 = this.maxQueueCapacity;
            if (mask + 1L == (long)maxCapacity2) {
                if (null == UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                    this.writeToQueue(buffer, e2, index2, offset);
                    return true;
                }
                return false;
            }
            if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(index2 + 1L, mask))) {
                this.writeToQueue(buffer, e2, index2, offset);
            } else {
                int newCapacity = (int)(2L * (mask + 1L));
                E[] newBuffer = CircularArrayOffsetCalculator.allocate(newCapacity + 1);
                this.producerBuffer = newBuffer;
                this.producerMask = newCapacity - 1;
                if (newCapacity == maxCapacity2) {
                    long currConsumerIndex = this.lvConsumerIndex();
                    this.producerLookAheadStep = -((int)(index2 - currConsumerIndex));
                    this.producerLimit = currConsumerIndex + (long)maxCapacity2 - 1L;
                } else {
                    this.producerLimit = index2 + this.producerMask - 1L;
                    this.adjustLookAheadStep(newCapacity);
                }
                long offsetInNew = CircularArrayOffsetCalculator.calcElementOffset(index2, this.producerMask);
                UnsafeRefArrayAccess.soElement(newBuffer, offsetInNew, e2);
                this.soNext(buffer, newBuffer);
                UnsafeRefArrayAccess.soElement(buffer, offset, JUMP);
                this.soProducerIndex(index2 + 1L);
            }
            return true;
        }
        int prevElementsInOtherBuffers = -lookAheadStep;
        long currConsumerIndex = this.lvConsumerIndex();
        int size = (int)(index2 - currConsumerIndex);
        if (size == (maxCapacity = (int)mask + 1)) {
            return false;
        }
        long firstIndexInCurrentBuffer = this.producerLimit - (long)maxCapacity + (long)prevElementsInOtherBuffers;
        if (currConsumerIndex >= firstIndexInCurrentBuffer) {
            this.adjustLookAheadStep(maxCapacity);
        } else {
            this.producerLookAheadStep = (int)(currConsumerIndex - firstIndexInCurrentBuffer);
        }
        this.producerLimit = currConsumerIndex + (long)maxCapacity;
        this.writeToQueue(buffer, e2, index2, offset);
        return true;
    }

    private void adjustLookAheadStep(int capacity) {
        this.producerLookAheadStep = Math.min(capacity / 4, SpscArrayQueue.MAX_LOOK_AHEAD_STEP);
    }
}

