/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffers;
import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.DefaultChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpMethod;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLogger;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import io.mantisrx.shaded.org.jboss.netty.util.CharsetUtil;
import java.net.URI;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketClientHandshaker13
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker13.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;

    public WebSocketClientHandshaker13(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, Map<String, String> customHeaders) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, Long.MAX_VALUE);
    }

    public WebSocketClientHandshaker13(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, Map<String, String> customHeaders, long maxFramePayloadLength) {
        super(webSocketURL, version, subprotocol, customHeaders, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    @Override
    public ChannelFuture handshake(Channel channel) throws Exception {
        URI wsURL = this.getWebSocketUrl();
        String path2 = wsURL.getPath();
        if (wsURL.getQuery() != null && wsURL.getQuery().length() > 0) {
            path2 = wsURL.getPath() + '?' + wsURL.getQuery();
        }
        if (path2 == null || path2.length() == 0) {
            path2 = "/";
        }
        ChannelBuffer nonce = ChannelBuffers.wrappedBuffer(WebSocketUtil.randomBytes(16));
        String key2 = WebSocketUtil.base64(nonce);
        String acceptSeed = key2 + MAGIC_GUID;
        ChannelBuffer sha1 = WebSocketUtil.sha1(ChannelBuffers.copiedBuffer((CharSequence)acceptSeed, CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("WS Version 13 Client Handshake key: %s. Expected response: %s.", key2, this.expectedChallengeResponseString));
        }
        int wsPort = wsURL.getPort();
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path2);
        request.addHeader("Upgrade", "WebSocket".toLowerCase());
        request.addHeader("Connection", "Upgrade");
        request.addHeader("Sec-WebSocket-Key", key2);
        request.addHeader("Host", wsURL.getHost() + ':' + wsPort);
        String originValue = "http://" + wsURL.getHost();
        if (wsPort != 80 && wsPort != 443) {
            originValue = originValue + ':' + wsPort;
        }
        request.addHeader("Origin", originValue);
        String expectedSubprotocol = this.getExpectedSubprotocol();
        if (expectedSubprotocol != null && expectedSubprotocol.length() != 0) {
            request.addHeader("Sec-WebSocket-Protocol", expectedSubprotocol);
        }
        request.addHeader("Sec-WebSocket-Version", "13");
        if (this.customHeaders != null) {
            for (Map.Entry e2 : this.customHeaders.entrySet()) {
                request.addHeader((String)e2.getKey(), e2.getValue());
            }
        }
        ChannelFuture future2 = channel.write(request);
        final DefaultChannelFuture handshakeFuture = new DefaultChannelFuture(channel, false);
        future2.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future2) {
                ChannelPipeline p = future2.getChannel().getPipeline();
                p.replace(HttpRequestEncoder.class, "ws-encoder", (ChannelHandler)new WebSocket13FrameEncoder(true));
                if (future2.isSuccess()) {
                    handshakeFuture.setSuccess();
                } else {
                    handshakeFuture.setFailure(future2.getCause());
                }
            }
        });
        return handshakeFuture;
    }

    @Override
    public void finishHandshake(Channel channel, HttpResponse response) {
        HttpResponseStatus status = HttpResponseStatus.SWITCHING_PROTOCOLS;
        if (!response.getStatus().equals(status)) {
            throw new WebSocketHandshakeException("Invalid handshake response status: " + response.getStatus());
        }
        String upgrade = response.getHeader("Upgrade");
        if (upgrade == null || !upgrade.toLowerCase().equals("WebSocket".toLowerCase())) {
            throw new WebSocketHandshakeException("Invalid handshake response upgrade: " + response.getHeader("Upgrade"));
        }
        String connection = response.getHeader("Connection");
        if (connection == null || !connection.toLowerCase().equals("Upgrade".toLowerCase())) {
            throw new WebSocketHandshakeException("Invalid handshake response connection: " + response.getHeader("Connection"));
        }
        String accept = response.getHeader("Sec-WebSocket-Accept");
        if (accept == null || !accept.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, this.expectedChallengeResponseString));
        }
        String subprotocol = response.getHeader("Sec-WebSocket-Protocol");
        this.setActualSubprotocol(subprotocol);
        this.setHandshakeComplete();
        channel.getPipeline().get(HttpResponseDecoder.class).replace("ws-decoder", new WebSocket13FrameDecoder(false, this.allowExtensions, this.getMaxFramePayloadLength()));
    }
}

