/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.embedder;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBufferFactory;
import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipelineException;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelSink;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelUpstreamHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.Channels;
import io.mantisrx.shaded.org.jboss.netty.channel.DefaultChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.ExceptionEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.embedder.CodecEmbedder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.embedder.CodecEmbedderException;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.embedder.EmbeddedChannel;
import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCodecEmbedder<E>
implements CodecEmbedder<E> {
    private final Channel channel;
    private final ChannelPipeline pipeline;
    private final EmbeddedChannelSink sink = new EmbeddedChannelSink();
    final Queue<Object> productQueue = new LinkedList<Object>();

    protected AbstractCodecEmbedder(ChannelHandler ... handlers) {
        this.pipeline = new EmbeddedChannelPipeline();
        this.configurePipeline(handlers);
        this.channel = new EmbeddedChannel(this.pipeline, this.sink);
        this.fireInitialEvents();
    }

    protected AbstractCodecEmbedder(ChannelBufferFactory bufferFactory, ChannelHandler ... handlers) {
        this(handlers);
        this.getChannel().getConfig().setBufferFactory(bufferFactory);
    }

    private void fireInitialEvents() {
        Channels.fireChannelOpen(this.channel);
        Channels.fireChannelBound(this.channel, this.channel.getLocalAddress());
        Channels.fireChannelConnected(this.channel, this.channel.getRemoteAddress());
    }

    private void configurePipeline(ChannelHandler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers should contain at least one " + ChannelHandler.class.getSimpleName() + '.');
        }
        for (int i = 0; i < handlers.length; ++i) {
            ChannelHandler h = handlers[i];
            if (h == null) {
                throw new NullPointerException("handlers[" + i + ']');
            }
            this.pipeline.addLast(String.valueOf(i), handlers[i]);
        }
        this.pipeline.addLast("SINK", this.sink);
    }

    @Override
    public boolean finish() {
        Channels.close(this.channel);
        Channels.fireChannelDisconnected(this.channel);
        Channels.fireChannelUnbound(this.channel);
        Channels.fireChannelClosed(this.channel);
        return !this.productQueue.isEmpty();
    }

    protected final Channel getChannel() {
        return this.channel;
    }

    protected final boolean isEmpty() {
        return this.productQueue.isEmpty();
    }

    @Override
    public final E poll() {
        return (E)this.productQueue.poll();
    }

    @Override
    public final E peek() {
        return (E)this.productQueue.peek();
    }

    @Override
    public final Object[] pollAll() {
        int size = this.size();
        Object[] a = new Object[size];
        for (int i = 0; i < size; ++i) {
            E product = this.poll();
            if (product == null) {
                throw new ConcurrentModificationException();
            }
            a[i] = product;
        }
        return a;
    }

    @Override
    public final <T> T[] pollAll(T[] a) {
        E product;
        if (a == null) {
            throw new NullPointerException("a");
        }
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        while ((product = this.poll()) != null) {
            a[i] = product;
            ++i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public final int size() {
        return this.productQueue.size();
    }

    @Override
    public ChannelPipeline getPipeline() {
        return this.pipeline;
    }

    private static final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        EmbeddedChannelPipeline() {
        }

        protected void notifyHandlerException(ChannelEvent e2, Throwable t) {
            while (t instanceof ChannelPipelineException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof CodecEmbedderException) {
                throw (CodecEmbedderException)t;
            }
            throw new CodecEmbedderException(t);
        }
    }

    private final class EmbeddedChannelSink
    implements ChannelSink,
    ChannelUpstreamHandler {
        EmbeddedChannelSink() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e2) {
            this.handleEvent(e2);
        }

        public void eventSunk(ChannelPipeline pipeline, ChannelEvent e2) {
            this.handleEvent(e2);
        }

        private void handleEvent(ChannelEvent e2) {
            if (e2 instanceof MessageEvent) {
                boolean offered = AbstractCodecEmbedder.this.productQueue.offer(((MessageEvent)e2).getMessage());
                assert (offered);
            } else if (e2 instanceof ExceptionEvent) {
                throw new CodecEmbedderException(((ExceptionEvent)e2).getCause());
            }
        }

        public void exceptionCaught(ChannelPipeline pipeline, ChannelEvent e2, ChannelPipelineException cause) throws Exception {
            Throwable actualCause = cause.getCause();
            if (actualCause == null) {
                actualCause = cause;
            }
            throw new CodecEmbedderException(actualCause);
        }

        public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
            try {
                task.run();
                return Channels.succeededFuture(pipeline.getChannel());
            }
            catch (Throwable t) {
                return Channels.failedFuture(pipeline.getChannel(), t);
            }
        }
    }
}

