/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.curator.framework.imps;

import io.mantisrx.shaded.org.apache.curator.CuratorZookeeperClient;
import io.mantisrx.shaded.org.apache.curator.RetryLoop;
import io.mantisrx.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import io.mantisrx.shaded.org.apache.curator.utils.EnsurePath;
import io.mantisrx.shaded.org.apache.curator.utils.PathUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ThreadUtils;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

class NamespaceImpl {
    private final CuratorFrameworkImpl client;
    private final String namespace;
    private final AtomicBoolean ensurePathNeeded;

    NamespaceImpl(CuratorFrameworkImpl client, String namespace2) {
        if (namespace2 != null) {
            try {
                PathUtils.validatePath("/" + namespace2);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("Invalid namespace: " + namespace2 + ", " + e2.getMessage());
            }
        }
        this.client = client;
        this.namespace = namespace2;
        this.ensurePathNeeded = new AtomicBoolean(namespace2 != null);
    }

    String getNamespace() {
        return this.namespace;
    }

    String unfixForNamespace(String path2) {
        String namespacePath;
        if (this.namespace != null && path2 != null && !(namespacePath = ZKPaths.makePath(this.namespace, null)).equals("/") && path2.startsWith(namespacePath)) {
            path2 = path2.length() > namespacePath.length() ? path2.substring(namespacePath.length()) : "/";
        }
        return path2;
    }

    String fixForNamespace(String path2, boolean isSequential) {
        if (this.ensurePathNeeded.get()) {
            try {
                final CuratorZookeeperClient zookeeperClient = this.client.getZookeeperClient();
                RetryLoop.callWithRetry(zookeeperClient, new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ZKPaths.mkdirs(zookeeperClient.getZooKeeper(), ZKPaths.makePath("/", NamespaceImpl.this.namespace), true, NamespaceImpl.this.client.getAclProvider(), true);
                        return null;
                    }
                });
                this.ensurePathNeeded.set(false);
            }
            catch (Exception e2) {
                ThreadUtils.checkInterrupted(e2);
                this.client.logError("Ensure path threw exception", e2);
            }
        }
        return ZKPaths.fixForNamespace(this.namespace, path2, isSequential);
    }

    EnsurePath newNamespaceAwareEnsurePath(String path2) {
        return new EnsurePath(this.fixForNamespace(path2, false), this.client.getAclProvider());
    }
}

