/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.internal.util.UtilityFunctions;

public final class OperatorDistinctUntilChanged<T, U>
implements Observable.Operator<T, T>,
Func2<U, U, Boolean> {
    final Func1<? super T, ? extends U> keySelector;
    final Func2<? super U, ? super U, Boolean> comparator;

    public static <T> OperatorDistinctUntilChanged<T, T> instance() {
        return Holder.INSTANCE;
    }

    public OperatorDistinctUntilChanged(Func1<? super T, ? extends U> keySelector) {
        this.keySelector = keySelector;
        this.comparator = this;
    }

    public OperatorDistinctUntilChanged(Func2<? super U, ? super U, Boolean> comparator2) {
        this.keySelector = UtilityFunctions.identity();
        this.comparator = comparator2;
    }

    @Override
    public Boolean call(U t1, U t2) {
        return t1 == t2 || t1 != null && t1.equals(t2);
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){
            U previousKey;
            boolean hasPrevious;

            @Override
            public void onNext(T t) {
                Object key2;
                try {
                    key2 = OperatorDistinctUntilChanged.this.keySelector.call(t);
                }
                catch (Throwable e2) {
                    Exceptions.throwOrReport(e2, child, t);
                    return;
                }
                Object currentKey = this.previousKey;
                this.previousKey = key2;
                if (this.hasPrevious) {
                    boolean comparison;
                    try {
                        comparison = OperatorDistinctUntilChanged.this.comparator.call(currentKey, key2);
                    }
                    catch (Throwable e3) {
                        Exceptions.throwOrReport(e3, child, key2);
                        return;
                    }
                    if (!comparison) {
                        child.onNext(t);
                    } else {
                        this.request(1L);
                    }
                } else {
                    this.hasPrevious = true;
                    child.onNext(t);
                }
            }

            @Override
            public void onError(Throwable e2) {
                child.onError(e2);
            }

            @Override
            public void onCompleted() {
                child.onCompleted();
            }
        };
    }

    static final class Holder {
        static final OperatorDistinctUntilChanged<?, ?> INSTANCE = new OperatorDistinctUntilChanged(UtilityFunctions.identity());

        Holder() {
        }
    }
}

